/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.mpp.ActualTypealiasToSpecialAnnotationUtils;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J(\u0010\u0013\u001a\u00020\u0007*\u00020\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0016\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0019\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDefaultArgumentsInExpectWithActualTypeAlias", "getMembersWithDefaultValueParametersUnlessAnnotation", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkTypeAliasToClassWithDeclarationSiteVariance", "expandedTypeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "checkTypeAliasWithUseSiteVariance", "expandedType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkTypeAliasWithComplexSubstitution", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n33#2:174\n1#3:175\n1#3:191\n865#4:176\n1761#4,3:177\n866#4:180\n1617#4,9:181\n1869#4:190\n1870#4:192\n1626#4:193\n*S KotlinDebug\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n*L\n36#1:174\n109#1:191\n106#1:176\n106#1:177,3\n106#1:180\n109#1:181,9\n109#1:190\n109#1:192\n109#1:193\n*E\n"})
public final class FirActualTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirActualTypeAliasChecker INSTANCE = new FirActualTypeAliasChecker();

    private FirActualTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isActual$iv = declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        this.checkDefaultArgumentsInExpectWithActualTypeAlias(declaration, context, reporter);
        ConeKotlinType coneKotlinType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(declaration.getExpandedTypeRef()));
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType expandedType = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(expandedType, context.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> expandedTypeSymbol = firClassLikeSymbol;
        if (expandedTypeSymbol instanceof FirTypeAliasSymbol) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_NOT_TO_CLASS(), (DiagnosticContext)context, null, 8, null);
        }
        this.checkTypeAliasToClassWithDeclarationSiteVariance(declaration, expandedTypeSymbol, context, reporter);
        this.checkTypeAliasWithUseSiteVariance(declaration, expandedType, context, reporter);
        this.checkTypeAliasWithComplexSubstitution(declaration, expandedType, context, reporter);
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            ClassId classId;
            if (ConeBuiltinTypeUtilsKt.isNothing(expandedType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NOTHING(), (DiagnosticContext)context, null, 8, null);
            }
            if (expandedType.isMarkedNullable()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE(), (DiagnosticContext)context, null, 8, null);
            }
            if (FirHelpersKt.getClassKind(expandedTypeSymbol) == ClassKind.ANNOTATION_CLASS && ActualTypealiasToSpecialAnnotationUtils.INSTANCE.isAnnotationProhibitedInActualTypeAlias(classId = expandedTypeSymbol.getClassId())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getACTUAL_TYPEALIAS_TO_SPECIAL_ANNOTATION(), (Object)classId, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final void checkDefaultArgumentsInExpectWithActualTypeAlias(FirTypeAlias $this$checkDefaultArgumentsInExpectWithActualTypeAlias, CheckerContext context, DiagnosticReporter reporter) {
        LanguageVersionSettings it = context.getLanguageVersionSettings();
        boolean bl = false;
        boolean bl2 = !it.supportsFeature(LanguageFeature.MultiplatformRestrictions) || !it.supportsFeature(LanguageFeature.MultiplatformRestrictions);
        if (bl2) {
            return;
        }
        FirTypeAliasSymbol actualTypealiasSymbol = $this$checkDefaultArgumentsInExpectWithActualTypeAlias.getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(actualTypealiasSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectedSingleCandidate = firBasedSymbol;
        FirRegularClassSymbol expectClassSymbol = (FirRegularClassSymbol)expectedSingleCandidate;
        List<FirFunctionSymbol<?>> membersWithDefaultValueParameters = this.getMembersWithDefaultValueParametersUnlessAnnotation(expectClassSymbol);
        if (membersWithDefaultValueParameters.isEmpty()) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkDefaultArgumentsInExpectWithActualTypeAlias.getSource(), FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS(), (Object)expectClassSymbol, membersWithDefaultValueParameters, (DiagnosticContext)context, null, 32, null);
    }

    private final List<FirFunctionSymbol<?>> getMembersWithDefaultValueParametersUnlessAnnotation(FirClassSymbol<?> classSymbol) {
        List result2 = new ArrayList();
        FirActualTypeAliasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, classSymbol);
        return result2;
    }

    private final void checkTypeAliasToClassWithDeclarationSiteVariance(FirTypeAlias $this$checkTypeAliasToClassWithDeclarationSiteVariance, FirClassLikeSymbol<?> expandedTypeSymbol, CheckerContext context, DiagnosticReporter reporter) {
        for (FirTypeParameterSymbol typeParameterSymbol : expandedTypeSymbol.getTypeParameterSymbols()) {
            if (typeParameterSymbol.getVariance() == Variance.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkTypeAliasToClassWithDeclarationSiteVariance.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE(), (DiagnosticContext)context, null, 8, null);
            break;
        }
    }

    private final void checkTypeAliasWithUseSiteVariance(FirTypeAlias $this$checkTypeAliasWithUseSiteVariance, ConeClassLikeType expandedType, CheckerContext context, DiagnosticReporter reporter) {
        for (ConeTypeProjection typeArgument : expandedType.getTypeArguments()) {
            if (typeArgument.getKind() == ProjectionKind.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkTypeAliasWithUseSiteVariance.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE(), (DiagnosticContext)context, null, 8, null);
            break;
        }
    }

    private final void checkTypeAliasWithComplexSubstitution(FirTypeAlias $this$checkTypeAliasWithComplexSubstitution, ConeClassLikeType expandedType, CheckerContext context, DiagnosticReporter reporter) {
        boolean reportActualTypeAliasWithComplexSubstitution = false;
        if ($this$checkTypeAliasWithComplexSubstitution.getTypeParameters().size() != expandedType.getTypeArguments().length) {
            reportActualTypeAliasWithComplexSubstitution = true;
        } else {
            int n = $this$checkTypeAliasWithComplexSubstitution.getTypeParameters().size();
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection typeArgument = expandedType.getTypeArguments()[i];
                if (typeArgument instanceof ConeTypeParameterType) {
                    if (Intrinsics.areEqual((Object)$this$checkTypeAliasWithComplexSubstitution.getTypeParameters().get(i).getSymbol(), (Object)((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol())) continue;
                    reportActualTypeAliasWithComplexSubstitution = true;
                    break;
                }
                if (!(typeArgument instanceof ConeKotlinType) || !(!(((ConeKotlinType)typeArgument).getTypeArguments().length == 0))) continue;
                reportActualTypeAliasWithComplexSubstitution = true;
                break;
            }
        }
        if (reportActualTypeAliasWithComplexSubstitution) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkTypeAliasWithComplexSubstitution.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(List<FirFunctionSymbol<?>> result2, FirClassSymbol<?> classSymbol) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv2;
        FirContainingNamesAwareScope memberScope2;
        if (classSymbol.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirContainingNamesAwareScope $this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u241 = memberScope2 = FirDeclaredMemberScopeProviderKt.declaredMemberScope(classSymbol, classSymbol.getModuleData().getSession(), null);
        boolean bl = false;
        List functionsAndConstructors = CollectionsKt.plus(FirContainingNamesAwareScopeKt.collectAllFunctions($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u241), (Iterable)FirScopeKt.getDeclaredConstructors($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u241));
        Iterable $this$filterTo$iv = functionsAndConstructors;
        boolean $i$f$filterTo22 = false;
        for (Object element$iv2 : $this$filterTo$iv) {
            boolean bl2;
            block7: {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv2;
                boolean bl3 = false;
                Iterable $this$any$iv = it.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        FirValueParameterSymbol p0 = (FirValueParameterSymbol)element$iv3;
                        boolean bl4 = false;
                        if (!p0.getHasDefaultValue()) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            ((Collection)result2).add(element$iv2);
        }
        Iterable $i$f$filterTo22 = memberScope2.getClassifierNames();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            Name it = (Name)element$iv$iv;
            boolean bl6 = false;
            FirClassifierSymbol<?> firClassifierSymbol = FirScopeKt.getSingleClassifier(memberScope2, it);
            if ((firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nestedClasses = (List)destination$iv$iv;
        for (FirClassSymbol nestedClassSymbol : nestedClasses) {
            FirActualTypeAliasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, nestedClassSymbol);
        }
    }
}

