/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.impl.DeduplicatingDiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.DeduplicatingDiagnosticReporterKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.DelegatedWrapperData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002&'B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J<\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001d*\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J0\u0010 \u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010\"\u001a\u00020#*\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002\u0082\u0001\u0002()\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInheritanceClash", "containingClass", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "classScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkValOverridesVar", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "checkDifferentNamesForTheSameParameterInSupertypes", "functionSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "collectCallablesNamed", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkConflictingMembers", "scope", "substituteTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fromDeclaration", "toDeclaration", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImplementationMismatchChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 8 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,355:1\n34#2:356\n1#3:357\n1#3:403\n1#3:433\n1#3:438\n1563#4:358\n1634#4,3:359\n1761#4,3:362\n1761#4,2:366\n1740#4,3:368\n1763#4:371\n774#4:372\n865#4,2:373\n1491#4:375\n1516#4,2:376\n1634#4,3:378\n1518#4:381\n1519#4,3:389\n1617#4,9:392\n1869#4:401\n1870#4:404\n1626#4:405\n3550#4,7:424\n1625#4:431\n1869#4:432\n1870#4:434\n1626#4:435\n1625#4:436\n1869#4:437\n1870#4:439\n1626#4:440\n14#5:365\n31#5:402\n384#6,7:382\n161#7:406\n137#7,4:407\n85#7:411\n141#7,2:413\n161#7:415\n137#7,4:416\n85#7:420\n141#7,2:422\n46#8:412\n46#8:421\n*S KotlinDebug\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker\n*L\n67#1:356\n306#1:403\n270#1:433\n278#1:438\n160#1:358\n160#1:359,3\n164#1:362,3\n180#1:366,2\n181#1:368,3\n180#1:371\n283#1:372\n283#1:373,2\n297#1:375\n297#1:376,2\n301#1:378,3\n297#1:381\n297#1:389,3\n306#1:392,9\n306#1:401\n306#1:404\n306#1:405\n348#1:424,7\n270#1:431\n270#1:432\n270#1:434\n270#1:435\n278#1:436\n278#1:437\n278#1:439\n278#1:440\n174#1:365\n308#1:402\n297#1:382,7\n313#1:406\n313#1:407,4\n313#1:411\n313#1:413,2\n314#1:415\n314#1:416,4\n314#1:420\n314#1:422,2\n313#1:412\n314#1:421\n*E\n"})
public abstract class FirImplementationMismatchChecker
extends FirDeclarationChecker<FirClass> {
    private FirImplementationMismatchChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        ClassKind classKind;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        KtSourceElementKind sourceKind = source.getKind();
        if (sourceKind instanceof KtFakeSourceElementKind && !Intrinsics.areEqual((Object)sourceKind, (Object)KtFakeSourceElementKind.EnumInitializer.INSTANCE)) {
            return;
        }
        if (declaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
        }
        if ((classKind = declaration.getClassKind()) == ClassKind.ANNOTATION_CLASS || classKind == ClassKind.ENUM_CLASS) {
            return;
        }
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(false, false, context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowDnnTypeOverridingFlexibleType));
        FirTypeScope classScope = FirHelpersKt.unsubstitutedScope(declaration, context);
        DeduplicatingDiagnosticReporter dedupReporter = DeduplicatingDiagnosticReporterKt.deduplicating(reporter);
        for (Name name2 : classScope.getCallableNames()) {
            classScope.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirImplementationMismatchChecker.check$lambda$0(this, declaration, context, dedupReporter, typeCheckerState, classScope, arg_0)));
            classScope.processPropertiesByName(name2, arg_0 -> FirImplementationMismatchChecker.check$lambda$1(this, declaration, context, dedupReporter, typeCheckerState, classScope, arg_0));
            this.checkConflictingMembers(declaration, context, dedupReporter, classScope, name2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInheritanceClash(FirClass containingClass, CheckerContext context, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirCallableSymbol<?> symbol, FirTypeScope classScope) {
        Object object;
        boolean bl;
        Iterable $this$any$iv;
        Pair someClash;
        List implementations;
        FirCallableSymbol delegation;
        List withTypes;
        block31: {
            boolean bl2;
            Collection intersectionSymbols;
            block29: {
                Iterator<Object> $this$mapTo$iv$iv;
                Collection collection;
                block36: {
                    block33: {
                        Collection<FirCallableSymbol<?>> collection2;
                        block35: {
                            List allOverridden;
                            block34: {
                                Object v0;
                                block28: {
                                    if (ClassMembersKt.isSubstitutionOverride(symbol)) {
                                        return;
                                    }
                                    if (ClassMembersKt.getDelegatedWrapperData(symbol) == null) break block33;
                                    allOverridden = FirTypeScopeKt.getDirectOverriddenMembers$default(classScope, symbol, false, 2, null);
                                    Iterable iterable = allOverridden;
                                    for (Object t : iterable) {
                                        FirCallableSymbol it = (FirCallableSymbol)t;
                                        boolean bl3 = false;
                                        if (!(it instanceof FirIntersectionCallableSymbol)) continue;
                                        v0 = t;
                                        break block28;
                                    }
                                    v0 = null;
                                }
                                if ((collection2 = (FirCallableSymbol)v0) == null) break block34;
                                FirCallableSymbol it = collection2;
                                boolean bl4 = false;
                                Collection<FirCallableSymbol<?>> collection3 = ((FirIntersectionCallableSymbol)((Object)it)).getIntersections();
                                collection2 = collection3;
                                if (collection3 != null) break block35;
                            }
                            collection2 = allOverridden;
                        }
                        Collection<FirCallableSymbol<?>> cleared = collection2;
                        collection = kotlin.collections.CollectionsKt.plus((Collection)cleared, symbol);
                        break block36;
                    }
                    if (symbol instanceof FirIntersectionCallableSymbol && !FirImplementationMismatchChecker.checkInheritanceClash$isTrivialIntersectionOverride(symbol, containingClass, classScope)) {
                        collection = ((FirIntersectionCallableSymbol)((Object)symbol)).getIntersections();
                    } else {
                        return;
                    }
                }
                intersectionSymbols = collection;
                Iterable $this$map$iv = intersectionSymbols;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl4 = $this$mapTo$iv$iv.iterator();
                while (bl4.hasNext()) {
                    void it;
                    Object item$iv$iv = bl4.next();
                    FirCallableSymbol bl3 = (FirCallableSymbol)item$iv$iv;
                    Collection collection4 = destination$iv$iv;
                    boolean bl5 = false;
                    collection4.add(TuplesKt.to((Object)it, (Object)context.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it).getConeType()));
                }
                withTypes = (List)destination$iv$iv;
                Iterable $this$any$iv2 = withTypes;
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        Pair it = (Pair)element$iv;
                        boolean bl6 = false;
                        if (!(it.getSecond() instanceof ConeErrorType)) continue;
                        bl2 = true;
                        break block29;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            delegation = null;
            implementations = new ArrayList();
            for (FirCallableSymbol intSymbol : intersectionSymbols) {
                DelegatedWrapperData delegatedWrapperData = ClassMembersKt.getDelegatedWrapperData(intSymbol);
                if (Intrinsics.areEqual((Object)(delegatedWrapperData != null && (delegatedWrapperData = delegatedWrapperData.getContainingClass()) != null ? ((ConeClassLikeLookupTag)((Object)delegatedWrapperData)).getClassId() : null), (Object)FirDeclarationUtilKt.getClassId(containingClass))) {
                    delegation = intSymbol;
                    break;
                }
                FirCallableSymbol $this$isAbstract$iv = intSymbol;
                boolean $i$f$isAbstract = false;
                if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) continue;
                implementations.add(intSymbol);
            }
            someClash = null;
            $this$any$iv = withTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    boolean bl7;
                    block30: {
                        Object element$iv = object.next();
                        Pair bl5 = (Pair)element$iv;
                        boolean bl8 = false;
                        FirCallableSymbol m1 = (FirCallableSymbol)bl5.component1();
                        ConeKotlinType type1 = (ConeKotlinType)bl5.component2();
                        Iterable $this$all$iv = withTypes;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                ConeKotlinType type2;
                                Pair pair = (Pair)element$iv2;
                                boolean bl9 = false;
                                FirCallableSymbol m2 = (FirCallableSymbol)pair.component1();
                                boolean result2 = FirImplementationMismatchChecker.checkInheritanceClash$canOverride(this, context, typeCheckerState, m1, type1, m2, type2 = (ConeKotlinType)pair.component2());
                                if (!result2 && someClash == null && !FirImplementationMismatchChecker.checkInheritanceClash$canOverride(this, context, typeCheckerState, m2, type2, m1, type1)) {
                                    someClash = TuplesKt.to((Object)m1, (Object)m2);
                                }
                                if (result2) continue;
                                bl7 = false;
                                break block30;
                            }
                            bl7 = true;
                        }
                    }
                    if (!bl7) continue;
                    bl = true;
                    break block31;
                }
                bl = false;
            }
        }
        boolean compatible = bl;
        $this$any$iv = someClash;
        if ($this$any$iv != null) {
            Object $i$f$any;
            Object it = object = $this$any$iv;
            boolean bl10 = false;
            Object object2 = $i$f$any = !compatible ? object : null;
            if ($i$f$any != null) {
                it = $i$f$any;
                boolean bl11 = false;
                FirCallableSymbol m1 = (FirCallableSymbol)it.component1();
                FirCallableSymbol m2 = (FirCallableSymbol)it.component2();
                FirImplementationMismatchChecker.checkInheritanceClash$reportTypeMismatch(reporter, containingClass, context, m1, m2, false);
                return;
            }
        }
        if (delegation != null || !((Collection)implementations).isEmpty()) {
            Object v10;
            FirCallableSymbol implementationMember;
            block32: {
                FirCallableSymbol firCallableSymbol = delegation;
                if (firCallableSymbol == null && (firCallableSymbol = (FirCallableSymbol)kotlin.collections.CollectionsKt.singleOrNull((List)implementations)) == null) {
                    return;
                }
                implementationMember = firCallableSymbol;
                ConeKotlinType implementationType = context.getReturnTypeCalculator().tryCalculateReturnType(implementationMember).getConeType();
                Iterable iterable = withTypes;
                for (Object t : iterable) {
                    ConeKotlinType baseType;
                    Pair pair = (Pair)t;
                    boolean bl12 = false;
                    FirCallableSymbol baseMember = (FirCallableSymbol)pair.component1();
                    if (!(!FirImplementationMismatchChecker.checkInheritanceClash$canOverride(this, context, typeCheckerState, implementationMember, implementationType, baseMember, baseType = (ConeKotlinType)pair.component2()))) continue;
                    v10 = t;
                    break block32;
                }
                v10 = null;
            }
            Pair pair = v10;
            if (pair == null) {
                return;
            }
            FirCallableSymbol conflict = (FirCallableSymbol)pair.component1();
            FirImplementationMismatchChecker.checkInheritanceClash$reportTypeMismatch(reporter, containingClass, context, implementationMember, conflict, delegation != null);
        }
    }

    private final void checkValOverridesVar(FirClass containingClass, CheckerContext context, DiagnosticReporter reporter, FirVariableSymbol<?> symbol, FirTypeScope classScope) {
        Object v0;
        block4: {
            if (!(symbol instanceof FirPropertySymbol) || ((FirPropertySymbol)symbol).isVar()) {
                return;
            }
            if (ClassMembersKt.getDelegatedWrapperData((FirCallableSymbol)symbol) == null) {
                return;
            }
            Iterable iterable = FirTypeScopeKt.getDirectOverriddenProperties(classScope, (FirPropertySymbol)symbol, true);
            for (Object t : iterable) {
                FirPropertySymbol it = (FirPropertySymbol)t;
                boolean bl = false;
                if (!it.isVar()) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        FirPropertySymbol firPropertySymbol = v0;
        if (firPropertySymbol == null) {
            return;
        }
        FirPropertySymbol overriddenVar = firPropertySymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL_BY_DELEGATION(), symbol, (Object)overriddenVar, (DiagnosticContext)context, null, 32, null);
    }

    private final void checkDifferentNamesForTheSameParameterInSupertypes(FirClass containingClass, CheckerContext context, DiagnosticReporter reporter, FirNamedFunctionSymbol functionSymbol, FirTypeScope classScope) {
        if (!(functionSymbol instanceof FirIntersectionCallableSymbol)) {
            return;
        }
        List overriddenFunctions = FirTypeScopeKt.getDirectOverriddenFunctions$default(classScope, functionSymbol, false, 2, null);
        int n = ((Collection)overriddenFunctions).size();
        for (int currentIndex = 0; currentIndex < n; ++currentIndex) {
            Object e = overriddenFunctions.get(currentIndex);
            FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)e;
            boolean bl = false;
            if ((FirNamedFunctionSymbol)(it.getResolvedStatus().getHasStableParameterNames() ? e : null) == null) continue;
            int n2 = overriddenFunctions.size();
            for (int otherIndex = currentIndex + 1; otherIndex < n2; ++otherIndex) {
                FirNamedFunctionSymbol otherFunctionSymbol;
                FirNamedFunctionSymbol currentFunctionSymbol;
                Object e2 = overriddenFunctions.get(otherIndex);
                FirNamedFunctionSymbol it2 = (FirNamedFunctionSymbol)e2;
                boolean bl2 = false;
                if ((FirNamedFunctionSymbol)(it2.getResolvedStatus().getHasStableParameterNames() ? e2 : null) == null) continue;
                DeclarationUtilsKt.checkValueParameterNamesWith(currentFunctionSymbol, otherFunctionSymbol, (Function3<? super FirValueParameterSymbol, ? super FirValueParameterSymbol, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FirImplementationMismatchChecker.checkDifferentNamesForTheSameParameterInSupertypes$lambda$14(reporter, containingClass, currentFunctionSymbol, otherFunctionSymbol, context, arg_0, arg_1, arg_2)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirCallableSymbol<?>> collectCallablesNamed(FirTypeScope $this$collectCallablesNamed, Name name2, FirClass containingClass, CheckerContext context) {
        void $this$filterTo$iv$iv;
        List allCallables = new ArrayList();
        $this$collectCallablesNamed.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirImplementationMismatchChecker.collectCallablesNamed$lambda$16(context, allCallables, arg_0)));
        $this$collectCallablesNamed.processPropertiesByName(name2, arg_0 -> FirImplementationMismatchChecker.collectCallablesNamed$lambda$18(context, allCallables, arg_0));
        Iterable $this$filter$iv = allCallables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!FirHelpersKt.isVisibleInClass(it, containingClass.getSymbol())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingMembers(FirClass containingClass, CheckerContext context, DiagnosticReporter reporter, FirTypeScope scope, Name name) {
        allCallables = this.collectCallablesNamed(scope, name, containingClass, context);
        $this$groupBy$iv = allCallables;
        $i$f$groupBy = false;
        var10_10 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            callable = (FirCallableSymbol)element$iv$iv;
            $i$a$-groupBy-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1 = false;
            $this$checkConflictingMembers_u24lambda_u2422_u24lambda_u2421 = var17_31 = kotlin.collections.CollectionsKt.createListBuilder();
            $i$a$-buildList-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1$1 = false;
            v0 = callable.getResolvedReceiverTypeRef();
            CollectionsKt.addIfNotNull($this$checkConflictingMembers_u24lambda_u2422_u24lambda_u2421, v0 != null ? v0.getConeType() : null);
            if (callable instanceof FirNamedFunctionSymbol) {
                $this$mapTo$iv = ((FirNamedFunctionSymbol)callable).getValueParameterSymbols();
                $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    var24_44 /* !! */  = (FirValueParameterSymbol)item$iv;
                    var25_45 = $this$checkConflictingMembers_u24lambda_u2422_u24lambda_u2421;
                    $i$a$-mapTo-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1$1$1 = false;
                    var25_45.add(it.getResolvedReturnTypeRef().getConeType());
                }
                (Collection)$this$checkConflictingMembers_u24lambda_u2422_u24lambda_u2421;
            }
            key$iv$iv = TuplesKt.to((Object)kotlin.collections.CollectionsKt.build((List)var17_31), (Object)(callable instanceof FirPropertySymbol));
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v1 /* !! */  = answer$iv$iv$iv;
            } else {
                v1 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v1 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        sameArgumentGroups = destination$iv$iv.values();
        $this$mapNotNull$iv = sameArgumentGroups;
        $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        $i$a$-groupBy-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1 = $this$forEach$iv$iv$iv.iterator();
        while ($i$a$-groupBy-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1.hasNext()) {
            block20: {
                element$iv$iv = element$iv$iv$iv = $i$a$-groupBy-FirImplementationMismatchChecker$checkConflictingMembers$sameArgumentGroups$1.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                fs = (List)element$iv$iv;
                $i$a$-mapNotNull-FirImplementationMismatchChecker$checkConflictingMembers$clashes$1 = false;
                var22_42 = kotlin.collections.CollectionsKt.zipWithNext((Iterable)fs);
                var23_43 = var22_42.iterator();
                while (var23_43.hasNext()) {
                    var24_44 /* !! */  = var23_43.next();
                    var25_45 = (Pair)var24_44 /* !! */ ;
                    $i$a$-find-FirImplementationMismatchChecker$checkConflictingMembers$clashes$1$1 = false;
                    m1 = (FirCallableSymbol)var25_45.component1();
                    m2 = (FirCallableSymbol)var25_45.component2();
                    $this$isSuspend$iv = m1;
                    $i$f$isSuspend = false;
                    v2 = $this$isSuspend$iv.getRawStatus().isSuspend();
                    $this$isSuspend$iv = m2;
                    $i$f$isSuspend = false;
                    if (!(v2 != $this$isSuspend$iv.getRawStatus().isSuspend() || m1.getTypeParameterSymbols().size() != m2.getTypeParameterSymbols().size())) continue;
                    v3 /* !! */  = var24_44 /* !! */ ;
                    break block20;
                }
                v3 /* !! */  = null;
            }
            if ((Pair)v3 /* !! */  == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        clashes = (List)destination$iv$iv;
        for (Pair clash : clashes) {
            $this$unwrapSubstitutionOverrides$iv = (FirCallableSymbol)clash.getFirst();
            $i$f$unwrapSubstitutionOverrides = false;
            $this$unwrapSubstitutionOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapSubstitutionOverrides$iv.getFir();
            $i$f$unwrapSubstitutionOverrides = false;
            current$iv$iv = $this$unwrapSubstitutionOverrides$iv$iv;
            while (true) {
                $this$originalForSubstitutionOverride$iv$iv$iv = current$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v4 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
                } else {
                    v4 = null;
                }
                if (v4 == null) break;
                current$iv$iv = next$iv$iv = v4;
            }
            if (current$iv$iv.getSymbol() == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            $this$unwrapSubstitutionOverrides$iv = (FirCallableSymbol)clash.getSecond();
            $i$f$unwrapSubstitutionOverrides = false;
            $this$unwrapSubstitutionOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapSubstitutionOverrides$iv.getFir();
            $i$f$unwrapSubstitutionOverrides = false;
            current$iv$iv = $this$unwrapSubstitutionOverrides$iv$iv;
            while (true) {
                $this$originalForSubstitutionOverride$iv$iv$iv = current$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v5 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
                } else {
                    v5 = null;
                }
                if (v5 == null) break;
                current$iv$iv = next$iv$iv = v5;
            }
            if (current$iv$iv.getSymbol() == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            firstClassLookupTag = ClassMembersKt.containingClassLookupTag(first);
            if (Intrinsics.areEqual((Object)firstClassLookupTag, (Object)(secondClassLookupTag = ClassMembersKt.containingClassLookupTag(second)))) continue;
            thisClassLookupTag = containingClass.getSymbol().toLookupTag();
            if (Intrinsics.areEqual((Object)firstClassLookupTag, (Object)thisClassLookupTag)) {
                v6 = first.getSource();
                if ((v6 != null ? v6.getKind() : null) instanceof KtRealSourceElementKind) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)first.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), (Object)TuplesKt.toList((Pair)clash), (DiagnosticContext)context, null, 16, null);
                    continue;
                }
            }
            if (Intrinsics.areEqual((Object)secondClassLookupTag, (Object)thisClassLookupTag)) {
                v7 = second.getSource();
                if ((v7 != null ? v7.getKind() : null) instanceof KtRealSourceElementKind) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)second.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), (Object)TuplesKt.toList((Pair)clash), (DiagnosticContext)context, null, 16, null);
                    continue;
                }
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getCONFLICTING_INHERITED_MEMBERS(), containingClass.getSymbol(), (Object)TuplesKt.toList((Pair)clash), (DiagnosticContext)context, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType substituteTypeParameters(ConeKotlinType $this$substituteTypeParameters, FirCallableSymbol<?> fromDeclaration, FirCallableSymbol<?> toDeclaration, CheckerContext context) {
        List<FirTypeParameterSymbol> fromParams = fromDeclaration.getTypeParameterSymbols();
        List<FirTypeParameterSymbol> toParams = toDeclaration.getTypeParameterSymbols();
        Iterable $this$zip$iv = fromParams;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)toParams).iterator();
        ArrayList<Pair> list$iv = new ArrayList<Pair>(Math.min(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)toParams, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void to;
            void from2;
            FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)second$iv.next();
            FirTypeParameterSymbol firTypeParameterSymbol2 = (FirTypeParameterSymbol)first$iv.next();
            ArrayList<Pair> arrayList = list$iv;
            boolean bl = false;
            arrayList.add(TuplesKt.to((Object)from2, (Object)FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)to)));
        }
        Map substitutionMap = MapsKt.toMap((Iterable)list$iv);
        return ConeSubstitutorByMapKt.substitutorByMap$default(substitutionMap, context.getSession(), false, 4, null).substituteOrSelf($this$substituteTypeParameters);
    }

    private static final Unit check$lambda$0(FirImplementationMismatchChecker this$0, FirClass $declaration, CheckerContext $context, DeduplicatingDiagnosticReporter $dedupReporter, TypeCheckerState $typeCheckerState, FirTypeScope $classScope, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkInheritanceClash($declaration, $context, $dedupReporter, $typeCheckerState, it, $classScope);
        this$0.checkDifferentNamesForTheSameParameterInSupertypes($declaration, $context, $dedupReporter, it, $classScope);
        return Unit.INSTANCE;
    }

    private static final Unit check$lambda$1(FirImplementationMismatchChecker this$0, FirClass $declaration, CheckerContext $context, DeduplicatingDiagnosticReporter $dedupReporter, TypeCheckerState $typeCheckerState, FirTypeScope $classScope, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkInheritanceClash($declaration, $context, $dedupReporter, $typeCheckerState, it, $classScope);
        this$0.checkValOverridesVar($declaration, $context, $dedupReporter, it, $classScope);
        return Unit.INSTANCE;
    }

    private static final void checkInheritanceClash$reportTypeMismatch(DiagnosticReporter $reporter, FirClass $containingClass, CheckerContext $context, FirCallableSymbol<?> member1, FirCallableSymbol<?> member2, boolean isDelegation) {
        KtDiagnosticFactory2<FirCallableSymbol<?>, FirCallableSymbol<?>> error = member1 instanceof FirPropertySymbol && member2 instanceof FirPropertySymbol ? (((FirPropertySymbol)member1).isVar() || ((FirPropertySymbol)member2).isVar() ? FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_INHERITANCE() : (isDelegation ? FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_BY_DELEGATION() : FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_INHERITANCE())) : (isDelegation ? FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_BY_DELEGATION() : FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_INHERITANCE());
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$containingClass.getSource(), error, member1, member2, (DiagnosticContext)$context, null, 32, null);
    }

    private static final boolean checkInheritanceClash$canOverride(FirImplementationMismatchChecker this$0, CheckerContext $context, TypeCheckerState $typeCheckerState, FirCallableSymbol<?> inheritedMember, ConeKotlinType inheritedType, FirCallableSymbol<?> baseMember, ConeKotlinType baseType) {
        ConeKotlinType inheritedTypeSubstituted = this$0.substituteTypeParameters(inheritedType, inheritedMember, baseMember, $context);
        return baseMember instanceof FirPropertySymbol && ((FirPropertySymbol)baseMember).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes($typeCheckerState, inheritedTypeSubstituted, baseType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $typeCheckerState, (KotlinTypeMarker)inheritedTypeSubstituted, (KotlinTypeMarker)baseType, false, 8, null);
    }

    private static final boolean checkInheritanceClash$isTrivialIntersectionOverride(FirCallableSymbol<?> $this$checkInheritanceClash_u24isTrivialIntersectionOverride, FirClass $containingClass, FirTypeScope $classScope) {
        return !Intrinsics.areEqual((Object)$this$checkInheritanceClash_u24isTrivialIntersectionOverride.getCallableId().getClassId(), (Object)FirDeclarationUtilKt.getClassId($containingClass)) || org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isTrivialIntersection(new MemberWithBaseScope($this$checkInheritanceClash_u24isTrivialIntersectionOverride, $classScope));
    }

    private static final Unit checkDifferentNamesForTheSameParameterInSupertypes$lambda$14(DiagnosticReporter $reporter, FirClass $containingClass, FirNamedFunctionSymbol $currentFunctionSymbol, FirNamedFunctionSymbol $otherFunctionSymbol, CheckerContext $context, FirValueParameterSymbol currentParameter, FirValueParameterSymbol otherParameter, int parameterIndex) {
        Intrinsics.checkNotNullParameter((Object)currentParameter, (String)"currentParameter");
        Intrinsics.checkNotNullParameter((Object)otherParameter, (String)"otherParameter");
        Object[] objectArray = new FirNamedFunctionSymbol[]{$currentFunctionSymbol, $otherFunctionSymbol};
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)$containingClass.getSource(), FirErrors.INSTANCE.getDIFFERENT_NAMES_FOR_THE_SAME_PARAMETER_IN_SUPERTYPES(), (Object)currentParameter, (Object)otherParameter, (Object)parameterIndex, (Object)kotlin.collections.CollectionsKt.listOf((Object[])objectArray), (DiagnosticContext)$context, null, 128, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectCallablesNamed$lambda$16(CheckerContext $context, List $allCallables, FirNamedFunctionSymbol sym) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
        if (sym instanceof FirIntersectionOverrideFunctionSymbol) {
            Iterable $this$mapNotNullTo$iv = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.getNonSubsumedOverriddenSymbols((FirIntersectionCallableSymbol)((Object)sym), $context.getSession(), $context.getScopeSession());
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirNamedFunctionSymbol it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                boolean bl2 = false;
                if ((it instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)it : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                ((Collection)$allCallables).add(it$iv);
            }
            object = $allCallables;
        } else {
            object = $allCallables.add(sym);
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectCallablesNamed$lambda$18(CheckerContext $context, List $allCallables, FirVariableSymbol sym) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
        if (sym instanceof FirIntersectionOverridePropertySymbol) {
            Iterable $this$mapNotNullTo$iv = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.getNonSubsumedOverriddenSymbols((FirIntersectionCallableSymbol)((Object)sym), $context.getSession(), $context.getScopeSession());
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirNamedFunctionSymbol it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                boolean bl2 = false;
                if ((it instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)it : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                ((Collection)$allCallables).add(it$iv);
            }
            object = $allCallables;
        } else {
            object = $allCallables.add(sym);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirImplementationMismatchChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirImplementationMismatchChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,355:1\n34#2:356\n*S KotlinDebug\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$ForExpectClass\n*L\n58#1:356\n*E\n"})
    public static final class ForExpectClass
    extends FirImplementationMismatchChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirImplementationMismatchChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,355:1\n34#2:356\n*S KotlinDebug\n*F\n+ 1 FirImplementationMismatchChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplementationMismatchChecker$Regular\n*L\n51#1:356\n*E\n"})
    public static final class Regular
    extends FirImplementationMismatchChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }
}

