/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.java.deserialization.FirJvmClasspathBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirCompositeSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.AbstractFirBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirFallbackBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J&\u0010\u001e\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J&\u0010 \u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020!0\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmBuiltinsSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "fallbackBuiltinSymbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirFallbackBuiltinSymbolProvider;", "findPackagePartData", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "Ljava/io/InputStream;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirFallbackBuiltinSymbolProvider;Lkotlin/jvm/functions/Function1;)V", "classpathBuiltinSymbolProvider", "Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmClasspathBuiltinSymbolProvider;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasPackage", "", "fqName", "java"})
public final class FirJvmBuiltinsSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirFallbackBuiltinSymbolProvider fallbackBuiltinSymbolProvider;
    @NotNull
    private final FirJvmClasspathBuiltinSymbolProvider classpathBuiltinSymbolProvider;

    public FirJvmBuiltinsSymbolProvider(@NotNull FirSession session2, @NotNull FirFallbackBuiltinSymbolProvider fallbackBuiltinSymbolProvider, @NotNull Function1<? super FqName, ? extends InputStream> findPackagePartData) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fallbackBuiltinSymbolProvider, (String)"fallbackBuiltinSymbolProvider");
        Intrinsics.checkNotNullParameter(findPackagePartData, (String)"findPackagePartData");
        super(session2);
        this.fallbackBuiltinSymbolProvider = fallbackBuiltinSymbolProvider;
        this.classpathBuiltinSymbolProvider = new FirJvmClasspathBuiltinSymbolProvider(session2, this.fallbackBuiltinSymbolProvider.getModuleData(), this.fallbackBuiltinSymbolProvider.getKotlinScopeProvider(), findPackagePartData);
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        Object[] objectArray = new AbstractFirBuiltinSymbolProvider[]{this.classpathBuiltinSymbolProvider, this.fallbackBuiltinSymbolProvider};
        return FirCompositeSymbolNamesProvider.Companion.fromSymbolProviders(CollectionsKt.listOf((Object[])objectArray));
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirRegularClassSymbol firRegularClassSymbol = this.classpathBuiltinSymbolProvider.getClassLikeSymbolByClassId(classId);
        if (firRegularClassSymbol == null) {
            firRegularClassSymbol = this.fallbackBuiltinSymbolProvider.getClassLikeSymbolByClassId(classId);
        }
        return firRegularClassSymbol;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelCallableSymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelCallableSymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelFunctionSymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelFunctionSymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int initSize = destination.size();
        this.classpathBuiltinSymbolProvider.getTopLevelPropertySymbolsTo(destination, packageFqName, name2);
        if (initSize == destination.size()) {
            this.fallbackBuiltinSymbolProvider.getTopLevelPropertySymbolsTo(destination, packageFqName, name2);
        }
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.classpathBuiltinSymbolProvider.hasPackage(fqName) || this.fallbackBuiltinSymbolProvider.hasPackage(fqName);
    }
}

