/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassInlineLike", "", "klass", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "unboxIntrinsic", "getUnboxIntrinsic", "getRuntimeClassFor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsInlineClassesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsInlineClassesUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class JsInlineClassesUtils
implements JsCommonInlineClassesUtils {
    @NotNull
    private final JsIrBackendContext context;

    public JsInlineClassesUtils(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof IrSimpleType) {
            IrClass irClass = IrTypeUtilsKt.erase(type2);
            if (irClass == null) {
                return null;
            }
            IrClass erased = irClass;
            if (this.isClassInlineLike(erased)) {
                if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = this.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        if (this.getInlinedClass(fieldType) == null) break;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    @Override
    public boolean isClassInlineLike(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return JsCommonInlineClassesUtils.super.isClassInlineLike(klass) || Intrinsics.areEqual((Object)klass.getSymbol().getSignature(), (Object)IdSignatureValues._char);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic() {
        return this.context.getIntrinsics().getJsBoxIntrinsic();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic() {
        return this.context.getIntrinsics().getJsUnboxIntrinsic();
    }

    @Nullable
    public final IrClass getRuntimeClassFor(@NotNull IrType type2) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrClass it = irClass = IrTypeErasureUtilsKt.getErasedUpperBound(type2);
        boolean bl = false;
        return !IrUtilsKt.isInterface(it) ? irClass : null;
    }
}

