/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0011j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0007`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "", "sourceRoots", "", "Ljava/io/File;", "outputDir", "includeUnavailableSourcesIntoSourceMap", "", "<init>", "(Ljava/util/List;Ljava/io/File;Z)V", "", "outputDirPathResolver", "Lorg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator;", "cache", "", "", "modulesAndTheirSourcesStatus", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getPathRelativeToSourceRoots", "file", "getPathRelativeToSourceRootsIfExists", "moduleId", "calculatePathRelativeToSourceRoots", "calculatePathRelativeToOutput", "Companion", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,78:1\n1634#2,3:79\n1#3:82\n384#4,7:83\n231#5:90\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n*L\n16#1:79,3\n33#1:83,7\n34#1:90\n*E\n"})
public final class SourceFilePathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean includeUnavailableSourcesIntoSourceMap;
    @NotNull
    private final Set<File> sourceRoots;
    @Nullable
    private final RelativePathCalculator outputDirPathResolver;
    @NotNull
    private final Map<File, String> cache;
    @NotNull
    private final HashMap<String, Boolean> modulesAndTheirSourcesStatus;

    /*
     * WARNING - void declaration
     */
    public SourceFilePathResolver(@NotNull List<? extends File> sourceRoots, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
        RelativePathCalculator relativePathCalculator;
        File destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        this.includeUnavailableSourcesIntoSourceMap = includeUnavailableSourcesIntoSourceMap;
        Iterable iterable = sourceRoots;
        Collection collection = new LinkedHashSet();
        SourceFilePathResolver sourceFilePathResolver = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file2 = (File)item$iv;
            void var12_12 = destination$iv;
            boolean bl = false;
            var12_12.add(it.getAbsoluteFile());
        }
        sourceFilePathResolver.sourceRoots = (Set)((Object)destination$iv);
        SourceFilePathResolver sourceFilePathResolver2 = this;
        File file3 = outputDir;
        if (file3 != null) {
            void p0;
            destination$iv = file3;
            sourceFilePathResolver = sourceFilePathResolver2;
            boolean bl = false;
            relativePathCalculator = new RelativePathCalculator((File)p0);
            sourceFilePathResolver2 = sourceFilePathResolver;
        } else {
            relativePathCalculator = null;
        }
        sourceFilePathResolver2.outputDirPathResolver = relativePathCalculator;
        this.cache = new LinkedHashMap();
        this.modulesAndTheirSourcesStatus = new HashMap();
    }

    public /* synthetic */ SourceFilePathResolver(List list, File file2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, file2, bl);
    }

    @NotNull
    public final String getPathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String path = this.cache.get(file2);
        if (path == null) {
            path = this.calculatePathRelativeToSourceRoots(file2);
            this.cache.put(file2, path);
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getPathRelativeToSourceRootsIfExists(@NotNull String moduleId, @NotNull File file2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.includeUnavailableSourcesIntoSourceMap) {
            Object object;
            Map $this$getOrPut$iv = this.modulesAndTheirSourcesStatus;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(moduleId);
            if (value$iv == null) {
                boolean bl = false;
                Boolean answer$iv = file2.exists();
                $this$getOrPut$iv.put(moduleId, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if ((Boolean)object == false) return null;
        }
        boolean bl = true;
        boolean moduleSourcesShouldBeAdded = bl;
        boolean $i$f$runIf = false;
        if (!moduleSourcesShouldBeAdded) return null;
        boolean bl2 = false;
        String string2 = this.getPathRelativeToSourceRoots(file2);
        return string2;
    }

    private final String calculatePathRelativeToSourceRoots(File file2) throws IOException {
        String pathRelativeToOutput;
        String string2 = pathRelativeToOutput = this.calculatePathRelativeToOutput(file2);
        if (string2 != null) {
            return string2;
        }
        List parts = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)file2.getAbsoluteFile(), (String)"getAbsoluteFile(...)");
        for (File currentFile = FilesKt.normalize((File)(v3920425)); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts.isEmpty()) break;
                CollectionsKt.reverse((List)parts);
                Iterable iterable = parts;
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
            }
            String string4 = currentFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            parts.add(string4);
        }
        String string5 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        return string5;
    }

    private final String calculatePathRelativeToOutput(File file2) {
        RelativePathCalculator relativePathCalculator = this.outputDirPathResolver;
        return relativePathCalculator != null ? relativePathCalculator.calculateRelativePathTo(file2) : null;
    }

    @JvmStatic
    @NotNull
    public static final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
        return Companion.create(sourceRoots, sourceMapPrefix, outputDir, includeUnavailableSourcesIntoSourceMap);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "sourceRoots", "", "", "sourceMapPrefix", "outputDir", "Ljava/io/File;", "includeUnavailableSourcesIntoSourceMap", "", "js.sourcemap"})
    @SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n1#3:83\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n*L\n71#1:79\n71#1:80,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
            File file2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
            Intrinsics.checkNotNullParameter((Object)sourceMapPrefix, (String)"sourceMapPrefix");
            boolean generateRelativePathsInSourceMap = ((CharSequence)sourceMapPrefix).length() == 0 && sourceRoots.isEmpty();
            Iterable $this$map$iv = sourceRoots;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            File $i$f$map22 = file2 = outputDir;
            collection = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = generateRelativePathsInSourceMap;
            File file3 = bl2 ? file2 : null;
            boolean bl3 = includeUnavailableSourcesIntoSourceMap;
            File file4 = file3;
            Collection collection2 = collection;
            return new SourceFilePathResolver((List<? extends File>)collection2, file4, bl3);
        }

        public static /* synthetic */ SourceFilePathResolver create$default(Companion companion, List list, String string2, File file2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.create(list, string2, file2, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

