/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeAliasExpander;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u0000 \u008d\u00012\u00020\u0001:\u0004\u008c\u0001\u008d\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020#H\u0002J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\n\u0010 \u001a\u0006\u0012\u0002\b\u000300H\u0002J\u001c\u00101\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\n\u0010 \u001a\u0006\u0012\u0002\b\u000300H\u0002J\u0018\u00102\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010<\u001a\u00020\u001c2\u0006\u00108\u001a\u00020=2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J \u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020(2\u0006\u0010 \u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020J2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010K\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020M2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010N\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;2\u0006\u00108\u001a\u00020=H\u0002J\u0010\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020CH\u0002J\u0010\u0010Q\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020CH\u0002J\u0010\u0010R\u001a\u00020\u001c2\u0006\u0010S\u001a\u00020MH\u0002J\u0010\u0010T\u001a\u00020\u001c2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010U\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010V\u001a\u00020\u001c2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010W\u001a\u00020\u001c2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]H\u0002J\u0018\u0010^\u001a\u00020\u001c2\u0006\u0010 \u001a\u0002032\u0006\u0010@\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020\u001c2\u0006\u0010 \u001a\u000203H\u0002J\u0010\u0010a\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020]H\u0002J \u0010b\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]2\u0006\u00108\u001a\u00020=H\u0002J\u0018\u0010c\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]H\u0002J@\u0010d\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020]2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010i\u001a\u00020h2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010n\u001a\u00020h2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0016\u0010o\u001a\u00020\u001c2\u0006\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020sJ\u0018\u0010t\u001a\u00020\u001c2\u0006\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020uH\u0002J\u0018\u0010v\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020w2\u0006\u0010@\u001a\u00020xH\u0002J\u0018\u0010y\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010\\\u001a\u00020]H\u0002J$\u0010z\u001a\u00020\u001c2\f\u0010{\u001a\b\u0012\u0004\u0012\u00020H0|2\f\u0010}\u001a\b\u0012\u0004\u0012\u00020H0kH\u0002J'\u0010~\u001a\u00020\u001c2\u0006\u0010\\\u001a\u00020]2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H\u0002J\u001c\u0010\u0083\u0001\u001a\u00020\u001c2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020=H\u0002J\u001a\u0010\u0087\u0001\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0007\u0010\u0088\u0001\u001a\u00020xH\u0002J\u0015\u0010\u0089\u0001\u001a\u00020\u001c2\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0016R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010j\u001a\b\u0012\u0004\u0012\u00020Z0k*\b\u0012\u0004\u0012\u00020Z0k8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010m\u00a8\u0006\u008e\u0001\u00b2\u0006\f\u0010\u008f\u0001\u001a\u00030\u0090\u0001X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "shadowedExtensionChecker", "Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "process", "", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkLocalTypeAliasDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkTypeAliasDeclaration", "checkActualTypeAlias", "getUsedTypeAliasParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeAlias", "checkTypeAliasExpansion", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "checkExpectedClassConstructor", "checkConstructorVisibility", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkLocalAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkTypesInClassHeader", "checkOnlyOneTypeParameterBound", "descriptor", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkPrimaryConstructor", "checkTypeParameters", "typeParameterListOwner", "checkTypeParameterConstraints", "checkConstructorInInterface", "klass", "checkMethodsOfAnyInInterface", "checkAnnotationClassMembers", "checkValOnAnnotationParameter", "checkOpenMembers", "checkBackingField", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkProperty", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkExpectDeclarationModifiers", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkExpectDeclarationHasNoExternalModifier", "checkPropertyTypeParametersAreUsedInReceiverType", "checkMemberProperty", "checkPropertyInitializer", "reportMustBeInitialized", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasAnyAccessorImplementation", "", "isOpenValDeferredInitDeprecationWarning", "deprecationWarning", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "getDeprecationWarning", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;)Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "noExplicitTypeOrGetterType", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkExpectedFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkAccessors", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "checkAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "checkVarargParameters", "callableDescriptor", "checkContextParameters", "contextReceiverList", "Lorg/jetbrains/kotlin/psi/KtContextReceiverList;", "TypeAliasDeclarationCheckingReportStrategy", "Companion", "frontend", "delegateClassScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;"})
@SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1167:1\n1563#2:1168\n1634#2,3:1169\n808#2,11:1172\n1761#2,3:1183\n1761#2,3:1186\n1563#2:1189\n1634#2,3:1190\n1625#2:1193\n1869#2:1194\n1870#2:1197\n1626#2:1198\n1563#2:1200\n1634#2,3:1201\n3307#2,10:1204\n774#2:1214\n865#2,2:1215\n1617#2,9:1217\n1869#2:1226\n1870#2:1228\n1626#2:1229\n1563#2:1230\n1634#2,3:1231\n295#2,2:1234\n1563#2:1236\n1634#2,3:1237\n1563#2:1240\n1634#2,3:1241\n1869#2,2:1244\n1869#2,2:1246\n2746#2,3:1248\n774#2:1251\n865#2,2:1252\n1869#2,2:1254\n1#3:1195\n1#3:1196\n1#3:1227\n192#4:1199\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n*L\n112#1:1168\n112#1:1169,3\n113#1:1172,11\n179#1:1183,3\n184#1:1186,3\n189#1:1189\n189#1:1190,3\n209#1:1193\n209#1:1194\n209#1:1197\n209#1:1198\n402#1:1200\n402#1:1201,3\n403#1:1204,10\n412#1:1214\n412#1:1215,2\n415#1:1217,9\n415#1:1226\n415#1:1228\n415#1:1229\n416#1:1230\n416#1:1231,3\n419#1:1234,2\n435#1:1236\n435#1:1237,3\n448#1:1240\n448#1:1241,3\n551#1:1244,2\n782#1:1246,2\n871#1:1248,3\n1061#1:1251\n1061#1:1252,2\n668#1:1254,2\n209#1:1196\n415#1:1227\n266#1:1199\n*E\n"})
public final class DeclarationsChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    @NotNull
    private final ExposedVisibilityChecker exposedChecker;
    @NotNull
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)annotationChecker, (String)"annotationChecker");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.upperBoundChecker = upperBoundChecker;
        ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = modifiersChecker.withTrace(this.trace);
        Intrinsics.checkNotNullExpressionValue((Object)modifiersCheckingProcedure, (String)"withTrace(...)");
        this.modifiersChecker = modifiersCheckingProcedure;
        this.exposedChecker = new ExposedVisibilityChecker(this.languageVersionSettings, this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        KtDeclarationStub declaration;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object propertyDescriptor;
        Intrinsics.checkNotNullParameter((Object)bodiesResolveContext, (String)"bodiesResolveContext");
        for (KtFile ktFile : bodiesResolveContext.getFiles()) {
            Intrinsics.checkNotNull((Object)ktFile);
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            this.annotationChecker.check(ktFile, this.trace, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getDeclaredClasses().entrySet()) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = (ClassDescriptorWithResolutionScopes)entry.getValue();
            Intrinsics.checkNotNull((Object)classDescriptor);
            Intrinsics.checkNotNull((Object)ktClassOrObject);
            this.checkClass(classDescriptor, ktClassOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(ktClassOrObject, classDescriptor);
            this.identifierChecker.checkDeclaration(ktClassOrObject, this.trace);
            this.exposedChecker.checkClassHeader(ktClassOrObject, classDescriptor);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction ktNamedFunction = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            Intrinsics.checkNotNull((Object)ktNamedFunction);
            Intrinsics.checkNotNull((Object)functionDescriptor);
            this.checkFunction(ktNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktNamedFunction, functionDescriptor);
            this.identifierChecker.checkDeclaration(ktNamedFunction, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty ktProperty = (KtProperty)entry.getKey();
            propertyDescriptor = (PropertyDescriptor)entry.getValue();
            Intrinsics.checkNotNull((Object)ktProperty);
            Intrinsics.checkNotNull((Object)propertyDescriptor);
            this.checkProperty(ktProperty, (PropertyDescriptor)propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktProperty, (MemberDescriptor)propertyDescriptor);
            this.identifierChecker.checkDeclaration(ktProperty, this.trace);
        }
        Iterable iterable = bodiesResolveContext.getDestructuringDeclarationEntries().entrySet();
        boolean bl = false;
        propertyDescriptor = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtDestructuringDeclarationEntry entry2 = (KtDestructuringDeclarationEntry)entry.getKey();
            collection.add(entry2.getParent());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl3 = false;
        $this$mapTo$iv$iv = iterable2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtDestructuringDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List destructuringDeclarations = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (KtDestructuringDeclaration ktDestructuringDeclaration : destructuringDeclarations) {
            this.modifiersChecker.checkModifiersForDestructuringDeclaration(ktDestructuringDeclaration);
            this.identifierChecker.checkDeclaration(ktDestructuringDeclaration, this.trace);
        }
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            declaration = entry.getKey();
            ClassConstructorDescriptor constructorDescriptor = entry.getValue();
            Intrinsics.checkNotNull((Object)constructorDescriptor);
            Intrinsics.checkNotNull((Object)declaration);
            this.checkConstructorDeclaration(constructorDescriptor, (KtConstructor<?>)declaration);
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, declaration, constructorDescriptor, null, 4, null);
        }
        for (Map.Entry<KtTypeAlias, TypeAliasDescriptor> entry : bodiesResolveContext.getTypeAliases().entrySet()) {
            declaration = entry.getKey();
            TypeAliasDescriptor typeAliasDescriptor = entry.getValue();
            Intrinsics.checkNotNull((Object)declaration);
            Intrinsics.checkNotNull((Object)typeAliasDescriptor);
            this.checkTypeAliasDeclaration((KtTypeAlias)declaration, typeAliasDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
            this.exposedChecker.checkTypeAlias((KtTypeAlias)declaration, typeAliasDescriptor);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration, typeAliasDescriptor);
        SimpleType expandedType = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType)) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType));
        }
        if (TypeUtils.contains((KotlinType)expandedType, (Function1<UnwrappedType, Boolean>)((Function1)DeclarationsChecker::checkTypeAliasDeclaration$lambda$1))) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (usedTypeAliasParameters.contains(typeParameter)) continue;
            Intrinsics.checkNotNull((Object)typeParameter);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter);
            if ((psiElement instanceof KtTypeParameter ? (KtTypeParameter)psiElement : null) == null) {
                throw new AssertionError((Object)("No source element for type parameter " + typeParameter + " of " + typeAliasDescriptor));
            }
            source = source;
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter, expandedType));
        }
        if (PsiUtilsKt.hasActualModifier(declaration)) {
            this.checkActualTypeAlias(declaration, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualTypeAlias(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        void $this$mapTo$iv$iv;
        boolean bl;
        SimpleType rhs;
        block15: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block14: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor instanceof ClassDescriptor)) {
                    this.trace.report(Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration)));
                    return;
                }
                List<TypeParameterDescriptor> list = ((ClassDescriptor)classDescriptor).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclaredTypeParameters(...)");
                $this$any$iv = list;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TypeParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(it.getVariance() != Variance.INVARIANT)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
            $this$any$iv = rhs.getArguments();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT || it.isStarProjection())) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
        Iterable $this$map$iv = rhs.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            collection.add(classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
        }
        if (!Intrinsics.areEqual((Object)((List)destination$iv$iv), typeAliasDescriptor.getDeclaredTypeParameters())) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            if (TypeUtilsKt.isNothing(rhs)) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_NOTHING.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
            if (rhs.isMarkedNullable()) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassifierDescriptor classifierDescriptor;
            TypeParameterDescriptor descriptor;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor2 = it.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor = descriptor = classifierDescriptor2 instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor2 : null;
            if (typeParameterDescriptor != null) {
                ClassifierDescriptor it2 = classifierDescriptor2 = typeParameterDescriptor;
                boolean bl3 = false;
                classifierDescriptor = Intrinsics.areEqual((Object)it2.getContainingDeclaration(), (Object)typeAlias) ? classifierDescriptor2 : null;
            } else {
                classifierDescriptor = null;
            }
            if (classifierDescriptor == null) continue;
            ClassifierDescriptor it$iv = classifierDescriptor;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration, this.upperBoundChecker);
        new TypeAliasExpander(reportStrategy, true).expandWithoutAbbreviation(typeAliasExpansion, TypeAttributes.Companion.getEmpty());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration);
        this.checkExpectedClassConstructor(constructorDescriptor, declaration);
        PsiElement $this$getChildOfType$iv = declaration;
        boolean $i$f$getChildOfType = false;
        this.checkContextParameters(PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KtContextReceiverList.class));
    }

    private final void checkExpectedClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isExpect()) {
            return;
        }
        if (declaration.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
            this.trace.report(Errors.EXPECTED_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration)));
        }
        if (declaration instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
            if (!InlineClassesUtilsKt.isValueClass(classDescriptor)) {
                for (KtParameter parameter : ((KtPrimaryConstructor)declaration).getValueParameters()) {
                    if (!parameter.hasValOrVar()) continue;
                    this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
            }
        }
        if (declaration instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration);
        Object object = visibilityModifier;
        if (object == null || (object = object.getNode()) == null || (object = object.getElementType()) == null) {
            return;
        }
        Object visibilityKeyword = object;
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            if (!Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
            }
        } else if (classDescriptor.getModality() == Modality.SEALED) {
            boolean protectedIsAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage);
            if (!(Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PRIVATE_KEYWORD) || protectedIsAllowed && Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PROTECTED_KEYWORD))) {
                DiagnosticFactory0<PsiElement> factory = protectedIsAllowed ? Errors.NON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED : Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED;
                this.trace.report(factory.on(visibilityModifier));
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList2 = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList2.getAnnotationEntries()) {
            KtSimpleNameExpression it;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            boolean bl = false;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(packageDirective, this.trace, null, this.languageVersionSettings);
    }

    private final void checkClass(ClassDescriptorWithResolutionScopes classDescriptor, KtClassOrObject classOrObject) {
        this.checkSupertypesForConsistency(classDescriptor, classOrObject);
        this.checkLocalAnnotation(classDescriptor, classOrObject);
        this.checkTypesInClassHeader(classOrObject);
        KtClassOrObject ktClassOrObject = classOrObject;
        if (ktClassOrObject instanceof KtClass) {
            this.checkClassButNotObject((KtClass)classOrObject, classDescriptor);
            this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            this.checkObject((KtObjectDeclaration)classOrObject, classDescriptor);
        }
        this.checkPrimaryConstructor(classOrObject, classDescriptor);
        this.checkExpectDeclarationModifiers(classOrObject, classDescriptor);
        this.checkContextParameters(classOrObject.getContextReceiverList());
    }

    private final void checkLocalAnnotation(ClassDescriptor classDescriptor, KtClassOrObject classOrObject) {
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && DescriptorUtils.isLocal(classDescriptor)) {
            this.trace.report(Errors.LOCAL_ANNOTATION_CLASS.on(this.languageVersionSettings, (KtClassOrObject)((PsiElement)classOrObject)));
        }
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType it;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) continue;
            if (DeclarationsChecker.checkTypesInClassHeader$type(typeReference2, this) == null) continue;
            boolean bl = false;
            this.upperBoundChecker.checkBoundsInSupertype(typeReference2, it, this.trace, this.languageVersionSettings);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter.getExtendsBound() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null) continue;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint : ((KtClass)classOrObject).getTypeConstraints()) {
            Object object;
            if (constraint.getBoundTypeReference() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null || (object = constraint.getSubjectTypeParameterName()) == null || (object = object.getReferencedNameAsName()) == null) continue;
            Object name2 = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name2, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests, false);
        Iterator iterator2 = upperBoundCheckRequests.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<KtElementImplStub> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            KtElementImplStub ktElementImplStub = iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)ktElementImplStub, (String)"next(...)");
            DescriptorResolver.UpperBoundCheckRequest request = (DescriptorResolver.UpperBoundCheckRequest)((Object)ktElementImplStub);
            KtTypeReference ktTypeReference = request.upperBound;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"upperBound");
            KotlinType kotlinType = request.upperBoundType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"upperBoundType");
            this.upperBoundChecker.checkBoundsInSupertype(ktTypeReference, kotlinType, this.trace, this.languageVersionSettings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        TypeConstructor constructor;
        void $this$partition$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<KotlinType> list = descriptor.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
        List<KotlinType> upperBounds = list;
        Iterable iterable = upperBounds;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getConstructor());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            constructor = (TypeConstructor)element$iv;
            boolean bl = false;
            boolean bl2 = constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        boolean bl = false;
        Pair pair2 = TuplesKt.to((Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getFirst())), (Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getSecond())));
        Set boundsWhichAreTypeParameters = (Set)pair2.component1();
        Set otherBounds = (Set)pair2.component2();
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object;
                Object v5;
                block10: {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object constraint;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<KtTypeConstraint> list2 = owner.getTypeConstraints();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeConstraints(...)");
                    Iterable $i$f$mapTo2 = list2;
                    boolean $i$f$filter = false;
                    constructor = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        constraint = (KtTypeConstraint)element$iv$iv;
                        boolean bl3 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = ((KtTypeConstraint)constraint).getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)declaration.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    constraint = $this$forEach$iv$iv$iv.iterator();
                    while (constraint.hasNext()) {
                        KtTypeReference it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = constraint.next();
                        boolean bl4 = false;
                        KtTypeConstraint constraint2 = (KtTypeConstraint)element$iv$iv;
                        boolean bl5 = false;
                        if (constraint2.getBoundTypeReference() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv2;
                    boolean $i$f$map2 = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void typeReference;
                        constraint = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl7 = false;
                        collection.add(TuplesKt.to((Object)typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)));
                    }
                    List allBounds = (List)destination$iv$iv2;
                    Iterable $this$firstOrNull$iv = allBounds;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair bound = (Pair)element$iv;
                        boolean bl8 = false;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(!Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.getConstructor() : null), (Object)CollectionsKt.first((Iterable)boundsWhichAreTypeParameters)))) continue;
                        v5 = element$iv;
                        break block10;
                    }
                    v5 = null;
                }
                ktModifierListOwnerStub = (object = (problematicBound = (Pair)v5)) != null && (object = (KtTypeReference)object.getFirst()) != null ? (KtModifierListOwnerStub)object : (KtModifierListOwnerStub)declaration;
            } else {
                ktModifierListOwnerStub = declaration;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
            MemberDescriptor memberDescriptor = declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null;
            boolean bl9 = memberDescriptor != null ? InlineOnlyKt.isInlineOnly(memberDescriptor) : false;
            if (bl9) {
                return;
            }
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier, PsiElement sourceElement) {
        Iterable it;
        Collection collection;
        Annotated annotated;
        if (classifier instanceof TypeParameterDescriptor) {
            void $this$mapTo$iv$iv;
            List<KotlinType> list = ((TypeParameterDescriptor)classifier).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                annotated = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((KotlinType)((Object)it)).getConstructor());
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet((Iterable)immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier.getDefaultType());
        Intrinsics.checkNotNullExpressionValue(multimap, (String)"buildDeepSubstitutionMultimap(...)");
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = multimap;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map = multiMap.asMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"asMap(...)");
        for (Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry : map.entrySet()) {
            ClassDescriptor containingDeclaration;
            void $this$mapTo$iv$iv;
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            Intrinsics.checkNotNull(projections);
            Iterable $this$map$iv = projections;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getType());
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            annotated = typeParameterDescriptor.getContainingDeclaration();
            if ((annotated instanceof ClassDescriptor ? (ClassDescriptor)annotated : null) == null) {
                throw new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration()));
            }
            containingDeclaration = containingDeclaration;
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) continue;
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClassButNotObject(KtClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass);
        this.checkTypeParameterConstraints(aClass);
        FiniteBoundRestrictionChecker.check(aClass, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass, classDescriptor, this.trace);
        if (aClass.isInterface()) {
            this.checkConstructorInInterface(aClass);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass), classDescriptor));
            }
        } else if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassMembers(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass, classDescriptor);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        PsiElement it;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructor = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor it2;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            boolean bl = false;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it2);
            Intrinsics.checkNotNull((Object)parameter);
            LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, parameter, it2);
        }
        if (!declaration.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                it = ktModifierList;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)it));
            }
        }
        if (declaration.getValueParameterList() == null) {
            PsiElement psiElement = declaration.getConstructorKeyword();
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_BRACKETS.on(it));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        this.checkConstructorDeclaration(primaryConstructor, declaration);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter ktTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor it;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ClassTypeParameterAnnotations)) {
                AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(ktTypeParameter, this.trace, this.languageVersionSettings);
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) continue;
            boolean bl = false;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, ktTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> list = typeParameterListOwner.getTypeConstraints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeConstraints(...)");
        List<KtTypeConstraint> constraints = list;
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter.getExtendsBound() != null) {
                Intrinsics.checkNotNull((Object)typeParameter);
                if (DeclarationsChecker.Companion.hasConstraints(typeParameter, constraints)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) continue;
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameter);
            this.checkSupertypesForConsistency(classifierDescriptor, typeParameter);
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor, typeParameter, typeParameterListOwner);
        }
        for (KtTypeConstraint constraint : constraints) {
            List<KtAnnotationEntry> list2 = constraint.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAnnotationEntries(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                this.trace.report(Errors.ANNOTATION_IN_WHERE_CLAUSE_WARNING.on((KtAnnotationEntry)((PsiElement)it)));
            }
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block0;
            KtPrimaryConstructor it = ktPrimaryConstructor;
            boolean bl = false;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassMembers(KtClassOrObject classOrObject) {
        for (KtDeclaration declaration : classOrObject.getDeclarations()) {
            if (declaration instanceof KtClassOrObject && this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInAnnotations)) continue;
            this.trace.report(Errors.ANNOTATION_CLASS_MEMBER.on(declaration));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass) {
        for (KtParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            Intrinsics.checkNotNull((Object)memberDescriptor);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor);
            KtNamedDeclaration member = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (member == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkBackingField(KtProperty property2) {
        block0: {
            KtBackingField ktBackingField = property2.getFieldDeclaration();
            if (ktBackingField == null) break block0;
            KtBackingField it = ktBackingField;
            boolean bl = false;
            this.trace.report(Errors.EXPLICIT_BACKING_FIELDS_UNSUPPORTED.on((KtElement)((PsiElement)it)));
        }
    }

    private final void checkProperty(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkMemberProperty(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, property2, propertyDescriptor);
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkTypeParameterConstraints(property2);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property2, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property2, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property2, propertyDescriptor);
        this.checkExpectDeclarationModifiers(property2, propertyDescriptor);
        this.checkBackingField(property2);
        this.checkContextParameters(property2.getContextReceiverList());
    }

    private final void checkExpectDeclarationModifiers(KtDeclaration declaration, MemberDescriptor descriptor) {
        block4: {
            if (!descriptor.isExpect()) {
                return;
            }
            if (DescriptorVisibilities.isPrivate(descriptor.getVisibility())) {
                PsiElement psiElement = declaration.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) {
                    psiElement = declaration;
                }
                this.trace.report(Errors.EXPECTED_PRIVATE_DECLARATION.on(psiElement));
            }
            this.checkExpectDeclarationHasNoExternalModifier(declaration);
            if (!(declaration instanceof KtFunction) || !this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) break block4;
            PsiElement psiElement = ((KtFunction)declaration).getModifierList();
            if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.TAILREC_KEYWORD)) != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.EXPECTED_TAILREC_FUNCTION.on(it));
            }
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(KtDeclaration declaration) {
        block1: {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) break block1;
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.EXTERNAL_KEYWORD)) != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.EXPECTED_EXTERNAL_DECLARATION.on(it));
            }
        }
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor) {
        List<TypeParameterDescriptor> list = descriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
        Set allTypeParameters = CollectionsKt.toSet((Iterable)list);
        HashSet<TypeParameterDescriptor> allAccessibleTypeParameters = new HashSet<TypeParameterDescriptor>();
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
        DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        for (ReceiverParameterDescriptor contextReceiverParameter : descriptor.getContextReceiverParameters()) {
            DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, contextReceiverParameter.getType());
        }
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus((Set)allTypeParameters, (Iterable)allAccessibleTypeParameters);
        for (TypeParameterDescriptor typeParameter : typeParametersInaccessibleFromReceiver) {
            Intrinsics.checkNotNull((Object)typeParameter);
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameter);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkMemberProperty(KtProperty property2, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList2 = property2.getModifierList();
        if (modifierList2 != null) {
            if (modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor)) {
                    PsiElement psiElement = property2;
                    String string2 = property2.getName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string2, classDescriptor));
                    return;
                }
            } else if (classDescriptor.getKind() == ClassKind.INTERFACE && modifierList2.hasModifier(KtTokens.OPEN_KEYWORD) && propertyDescriptor.getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property2)));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyAccessor setter2;
            KtElement it;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression != null) {
                it = ktExpression;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it));
            }
            KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
            if (ktPropertyDelegate != null) {
                it = ktPropertyDelegate;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it));
            }
            KtPropertyAccessor getter2 = property2.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property2.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        block40: {
            block41: {
                block38: {
                    block43: {
                        block42: {
                            block39: {
                                hasAnyAccessorImplementation = DeclarationsChecker.Companion.hasAnyAccessorImplementation(propertyDescriptor);
                                v0 = propertyDescriptor.getContainingDeclaration();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getContainingDeclaration(...)");
                                containingDeclaration = v0;
                                inInterface = DescriptorUtils.isInterface(containingDeclaration);
                                if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                                    if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                                        this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
                                    }
                                    if (inInterface && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                                        this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                    }
                                    return;
                                }
                                v1 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                                v2 = backingFieldRequired = v1 != null ? v1 : false;
                                if (inInterface && backingFieldRequired && hasAnyAccessorImplementation) {
                                    this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                }
                                initializer = property.getInitializer();
                                delegate = property.getDelegate();
                                isExpect = propertyDescriptor.isExpect();
                                if (initializer == null) break block39;
                                if (inInterface) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer)));
                                } else if (isExpect) {
                                    this.trace.report(Errors.EXPECTED_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer)));
                                } else if (!backingFieldRequired) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else if (property.getReceiverTypeReference() != null) {
                                    this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else {
                                    v3 = property.getContextReceivers();
                                    Intrinsics.checkNotNullExpressionValue(v3, (String)"getContextReceivers(...)");
                                    if (((Collection)v3).isEmpty() == false) {
                                        this.trace.report(Errors.CONTEXT_RECEIVERS_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                    }
                                }
                                break block40;
                            }
                            if (delegate == null) break block41;
                            if (!inInterface) break block42;
                            this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
                            break block40;
                        }
                        if (!isExpect) break block43;
                        this.trace.report(Errors.EXPECTED_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)delegate)));
                        break block40;
                    }
                    if (property.getReceiverTypeReference() == null) break block40;
                    delegatedPropertyResolvedCall = (ResolvedCall)this.trace.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
                    provideDelegateResolvedCall = (ResolvedCall)this.trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
                    v4 = provideDelegateResolvedCall;
                    if (v4 == null || (v4 = (FunctionDescriptor)v4.getResultingDescriptor()) == null || (v4 = v4.getReturnType()) == null) {
                        v5 = delegate.getExpression();
                        if (v5 != null) {
                            it = v5;
                            $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateType$1 = false;
                            v6 = this.trace.getType(it);
                        } else {
                            v6 = v4 = null;
                        }
                        if (v6 == null) {
                            return;
                        }
                    }
                    delegateType = v4;
                    it = FlexibleTypesKt.lowerIfFlexible((KotlinType)delegateType).unwrap().getConstructor().getDeclarationDescriptor();
                    $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateClassDescriptor$1 = false;
                    v7 = it instanceof ClassDescriptor != false ? (ClassDescriptor)it : null;
                    var15_21 = v7 != null ? (ClassifierDescriptor)v7 : ((v8 = it instanceof TypeAliasDescriptor != false ? (TypeAliasDescriptor)it : null) != null && (v8 = v8.getExpandedType()) != null && (v8 = v8.getConstructor()) != null ? v8.getDeclarationDescriptor() : null);
                    v9 = var15_21 instanceof ClassDescriptor != false ? (ClassDescriptor)var15_21 : null;
                    if (v9 == null) {
                        return;
                    }
                    delegateClassDescriptor = v9;
                    delegateClassScope$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkPropertyInitializer$lambda$32(org.jetbrains.kotlin.descriptors.ClassDescriptor ), ()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;)((ClassDescriptor)delegateClassDescriptor));
                    v10 = delegatedPropertyResolvedCall;
                    dispatchReceiverType = v10 != null && (v10 = v10.getDispatchReceiver()) != null ? v10.getType() : null;
                    v11 = delegatedPropertyResolvedCall;
                    extensionReceiverType = v11 != null && (v11 = v11.getExtensionReceiver()) != null ? v11.getType() : null;
                    v12 = propertyDescriptor.getTypeParameters();
                    Intrinsics.checkNotNullExpressionValue(v12, (String)"getTypeParameters(...)");
                    $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateType$1 = v12;
                    for (T var21_27 : $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateType$1) {
                        typeParameter = (TypeParameterDescriptor)var21_27;
                        $i$a$-find-DeclarationsChecker$checkPropertyInitializer$usedParameter$1 = false;
                        v13 = dispatchReceiverType;
                        if (v13 != null ? TypeUtilsKt.contains(v13, (Function1<? super UnwrappedType, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkPropertyInitializer$lambda$36$lambda$34(org.jetbrains.kotlin.descriptors.TypeParameterDescriptor org.jetbrains.kotlin.types.UnwrappedType ), (Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;)((TypeParameterDescriptor)typeParameter)) : false) ** GOTO lbl-1000
                        v14 = extensionReceiverType;
                        v15 = v14 != null ? TypeUtilsKt.contains(v14, (Function1<? super UnwrappedType, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkPropertyInitializer$lambda$36$lambda$35(org.jetbrains.kotlin.descriptors.TypeParameterDescriptor org.jetbrains.kotlin.types.UnwrappedType ), (Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;)((TypeParameterDescriptor)typeParameter)) : false;
                        if (v15) lbl-1000:
                        // 2 sources

                        {
                            v16 = true;
                        } else {
                            v16 = false;
                        }
                        if (!v16) continue;
                        v17 = var21_27;
                        break block38;
                    }
                    v17 = null;
                }
                usedParameter = v17;
                if (usedParameter != null) {
                    propertyWithTypeParameterTypeFound = false;
                    names = DeclarationsChecker.checkPropertyInitializer$lambda$33((Lazy<? extends MemberScope>)delegateClassScope$delegate).getVariableNames();
                    for (Name name : names) {
                        typeParameter = DeclarationsChecker.checkPropertyInitializer$lambda$33((Lazy<? extends MemberScope>)delegateClassScope$delegate).getContributedVariables(name, new KotlinLookupLocation(delegate));
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            propertyInDelegateClass = (PropertyDescriptor)element$iv;
                            $i$a$-forEach-DeclarationsChecker$checkPropertyInitializer$1 = false;
                            v18 = propertyInDelegateClass.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getType(...)");
                            if (!TypeUtilsKt.contains(v18, (Function1<? super UnwrappedType, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkPropertyInitializer$lambda$38$lambda$37(org.jetbrains.kotlin.types.UnwrappedType ), (Lorg/jetbrains/kotlin/types/UnwrappedType;)Ljava/lang/Boolean;)())) continue;
                            propertyWithTypeParameterTypeFound = true;
                        }
                    }
                    if (!propertyWithTypeParameterTypeFound) {
                        return;
                    }
                    this.trace.report(Errors.DELEGATE_USES_EXTENSION_PROPERTY_TYPE_PARAMETER.on(this.languageVersionSettings, (KtPropertyDelegate)((PsiElement)delegate), usedParameter.getName().asString()));
                }
                break block40;
            }
            v19 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            isUninitialized = v19 != null ? v19 : false;
            isExternal = DescriptorUtilsKt.isEffectivelyExternal(propertyDescriptor);
            if (backingFieldRequired && !inInterface && !propertyDescriptor.isLateInit() && !isExpect && isUninitialized && !isExternal) {
                if (propertyDescriptor.getExtensionReceiverParameter() != null && !hasAnyAccessorImplementation) {
                    this.trace.report(Errors.EXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                } else if (this.diagnosticSuppressor.shouldReportNoBody(propertyDescriptor)) {
                    isOpenValDeferredInitDeprecationWarning = this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitOpenValDeferredInitialization) == false && DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, this.languageVersionSettings) == Modality.OPEN && propertyDescriptor.isVar() == false && Intrinsics.areEqual(this.trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), (Object)false) != false;
                    v20 = isFalsePositiveDeferredInitDeprecationWarning = isOpenValDeferredInitDeprecationWarning != false && DeclarationsCheckerKt.access$getEffectiveModality(propertyDescriptor) == Modality.FINAL;
                    if (!isFalsePositiveDeferredInitDeprecationWarning) {
                        this.reportMustBeInitialized(propertyDescriptor, containingDeclaration, hasAnyAccessorImplementation, property, isOpenValDeferredInitDeprecationWarning, this.languageVersionSettings, this.trace);
                    }
                }
            } else if (property.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.ShortSyntaxForPropertyGetters, (Object)this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (propertyDescriptor.isLateInit()) {
                if (propertyDescriptor.isExpect()) {
                    v21 /* !! */  = property.getModifierList();
                    if (v21 /* !! */  == null || (v21 /* !! */  = v21 /* !! */ .getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
                        v21 /* !! */  = property;
                    }
                    this.trace.report(Errors.EXPECTED_LATEINIT_PROPERTY.on(v21 /* !! */ ));
                }
                if (backingFieldRequired && !inInterface && !isUninitialized && !Intrinsics.areEqual(this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor), (Object)true)) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void reportMustBeInitialized(PropertyDescriptor propertyDescriptor, DeclarationDescriptor containingDeclaration, boolean hasAnyAccessorImplementation, KtProperty property, boolean isOpenValDeferredInitDeprecationWarning, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        block11: {
            if (!(DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, languageVersionSettings) != Modality.ABSTRACT)) {
                $i$a$-check-DeclarationsChecker$reportMustBeInitialized$1 = false;
                $i$a$-check-DeclarationsChecker$reportMustBeInitialized$1 = "reportMustBeInitialized isn't called for abstract properties";
                throw new IllegalStateException($i$a$-check-DeclarationsChecker$reportMustBeInitialized$1.toString());
            }
            suggestMakingItFinal = containingDeclaration instanceof ClassDescriptor != false && org.jetbrains.kotlin.resolve.DeclarationsChecker$Companion.access$hasSetterAccessorImplementation(DeclarationsChecker.Companion, propertyDescriptor) == false && DeclarationsCheckerKt.getEffectiveModality(propertyDescriptor, languageVersionSettings) != Modality.FINAL && Intrinsics.areEqual(trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), (Object)false) != false;
            v0 = suggestMakingItAbstract = containingDeclaration instanceof ClassDescriptor != false && hasAnyAccessorImplementation == false;
            if (isOpenValDeferredInitDeprecationWarning && !suggestMakingItFinal && suggestMakingItAbstract) {
                throw new IllegalStateException("Not reachable case. Every \"open val + deferred init\" case that could be made `abstract`, also could be made `final`".toString());
            }
            if (languageVersionSettings.supportsFeature(LanguageFeature.ProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor) || !(containingDeclaration instanceof ClassDescriptor)) ** GOTO lbl-1000
            v1 = ((ClassDescriptor)containingDeclaration).getConstructors();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getConstructors(...)");
            $this$none$iv = v1;
            $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                v2 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ClassConstructorDescriptor)element$iv;
                    $i$a$-none-DeclarationsChecker$reportMustBeInitialized$isMissedMustBeInitializedDeprecationWarning$1 = false;
                    if (!it.isPrimary()) continue;
                    v2 = false;
                    break block11;
                }
                v2 = true;
            }
        }
        if (v2 && Intrinsics.areEqual(trace.getBindingContext().get(BindingContext.IS_DEFINITELY_NOT_ASSIGNED_IN_CONSTRUCTOR, propertyDescriptor), (Object)false)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isMissedMustBeInitializedDeprecationWarning = v3;
        factory = suggestMakingItFinal != false && suggestMakingItAbstract != false ? Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT : (suggestMakingItFinal != false ? Errors.MUST_BE_INITIALIZED_OR_BE_FINAL : (suggestMakingItAbstract != false ? Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT : Errors.MUST_BE_INITIALIZED));
        v4 = var12_13 = isMissedMustBeInitializedDeprecationWarning != false || isOpenValDeferredInitDeprecationWarning != false;
        if (var12_13) {
            Intrinsics.checkNotNull(factory);
            v5 = this.getDeprecationWarning(factory);
        } else if (!var12_13) {
            v5 = factory;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        trace.report(v5.on((KtProperty)((PsiElement)property)));
    }

    private final DiagnosticFactory0<KtProperty> getDeprecationWarning(DiagnosticFactory0<KtProperty> $this$deprecationWarning) {
        DiagnosticFactory0<KtProperty> diagnosticFactory0;
        DiagnosticFactory0<KtProperty> diagnosticFactory02 = $this$deprecationWarning;
        if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory03 = Errors.MUST_BE_INITIALIZED_WARNING;
            diagnosticFactory0 = diagnosticFactory03;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory03, (String)"MUST_BE_INITIALIZED_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory04 = Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING;
            diagnosticFactory0 = diagnosticFactory04;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory04, (String)"MUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_BE_FINAL)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory05 = Errors.MUST_BE_INITIALIZED_OR_BE_FINAL_WARNING;
            diagnosticFactory0 = diagnosticFactory05;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory05, (String)"MUST_BE_INITIALIZED_OR_BE_FINAL_WARNING");
        } else if (Intrinsics.areEqual(diagnosticFactory02, Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT)) {
            DiagnosticFactory0<KtProperty> diagnosticFactory06 = Errors.MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING;
            diagnosticFactory0 = diagnosticFactory06;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory06, (String)"MUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING");
        } else {
            throw new IllegalStateException("Only MUST_BE_INITIALIZED is supported".toString());
        }
        return diagnosticFactory0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property2) {
        if (property2.getTypeReference() != null) return false;
        if (property2.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor2);
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isExpectClass = ((ClassDescriptor)containingDescriptor).isExpect();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractDeclaration((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!((ClassDescriptor)containingDescriptor).isExpect() && !hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isExpectClass || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isExpect() || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isExpect()) {
            this.checkExpectedFunction(function2, functionDescriptor);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
        this.checkContextParameters(function2.getContextReceiverList());
    }

    private final void checkExpectedFunction(KtNamedFunction function2, FunctionDescriptor functionDescriptor) {
        if (function2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        this.checkExpectDeclarationModifiers(function2, functionDescriptor);
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType = descriptor.getReturnType();
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) break block2;
                it = kotlinType;
                boolean bl = false;
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = target = (PsiElement)declaration;
                }
                if (declaration.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)DeclarationsChecker::checkImplicitCallableType$lambda$42$lambda$41))) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property2.getGetter() : property2.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property2, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property2.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property2.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isExpect() && accessor.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Object[] objectArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        Map<KtModifierKeywordToken, PsiElement> map = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, SetsKt.setOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTokensCorrespondingToModifiers(...)");
        Map<KtModifierKeywordToken, PsiElement> tokens = map;
        if (accessor.isGetter()) {
            if (!Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)propertyDescriptor.getVisibility())) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityUtilsKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !Intrinsics.areEqual((Object)propertyDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = DescriptorVisibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || compare > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"SETTER_VISIBILITY_INCONS\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
        if (propertyDescriptor.isExpect()) {
            this.checkExpectDeclarationHasNoExternalModifier(accessor);
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor enumClass = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass)) {
            if (enumClass.isExpect() && enumEntry.getBody() != null) {
                this.trace.report(Errors.EXPECTED_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw new AssertionError((Object)string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        void $this$filterTo$iv$iv;
        List<ValueParameterDescriptor> list = callableDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (ValueParameterDescriptor parameter : varargParameters) {
                KtParameter parameterDeclaration;
                Intrinsics.checkNotNull((Object)parameter);
                PsiElement $i$f$filterTo2 = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
                if (($i$f$filterTo2 instanceof KtParameter ? (KtParameter)$i$f$filterTo2 : null) == null) continue;
                parameterDeclaration = parameterDeclaration;
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableNothingType(...)");
        SimpleType nullableNothing = simpleType;
        for (ValueParameterDescriptor parameter : varargParameters) {
            KtParameter parameterDeclaration;
            KotlinType kotlinType = parameter.getVarargElementType();
            Intrinsics.checkNotNull((Object)kotlinType);
            SimpleType varargElementType = FlexibleTypesKt.upperIfFlexible(kotlinType);
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType, nullableNothing) && (!InlineClassesUtilsKt.isInlineClassType(varargElementType) || UnsignedTypes.isUnsignedType(varargElementType) || KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(varargElementType))) continue;
            Intrinsics.checkNotNull((Object)parameter);
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            if ((psiElement instanceof KtParameter ? (KtParameter)psiElement : null) == null) continue;
            parameterDeclaration = parameterDeclaration;
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType));
        }
    }

    private final void checkContextParameters(KtContextReceiverList contextReceiverList) {
        KtContextReceiverList ktContextReceiverList = contextReceiverList;
        Collection collection = ktContextReceiverList != null ? ktContextReceiverList.contextParameters() : null;
        if (!(collection == null || collection.isEmpty())) {
            this.trace.report(Errors.CONTEXT_PARAMETERS_UNSUPPORTED.on((KtElement)((PsiElement)contextReceiverList)));
        }
    }

    private static final Boolean checkTypeAliasDeclaration$lambda$1(UnwrappedType it) {
        return TypeUtilsKt.isArrayOfNothing(it);
    }

    private static final KotlinType checkTypesInClassHeader$type(KtTypeReference $this$checkTypesInClassHeader_u24type, DeclarationsChecker this$0) {
        return (KotlinType)this$0.trace.getBindingContext().get(BindingContext.TYPE, $this$checkTypesInClassHeader_u24type);
    }

    private static final Boolean checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType$lambda$27(Set $allTypeParameters, HashSet $allAccessibleTypeParameters, UnwrappedType it) {
        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor && $allTypeParameters.contains(declarationDescriptor) && $allAccessibleTypeParameters.add(declarationDescriptor)) {
            List<KotlinType> list = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinType p0 = (KotlinType)element$iv;
                boolean bl = false;
                DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType($allTypeParameters, $allAccessibleTypeParameters, p0);
            }
        }
        return false;
    }

    private static final void checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(Set<? extends TypeParameterDescriptor> allTypeParameters, HashSet<TypeParameterDescriptor> allAccessibleTypeParameters, KotlinType type2) {
        TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)arg_0 -> DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType$lambda$27(allTypeParameters, allAccessibleTypeParameters, arg_0)));
    }

    private static final MemberScope checkPropertyInitializer$lambda$32(ClassDescriptor $delegateClassDescriptor) {
        return $delegateClassDescriptor.getUnsubstitutedMemberScope();
    }

    private static final MemberScope checkPropertyInitializer$lambda$33(Lazy<? extends MemberScope> $delegateClassScope$delegate) {
        Lazy<? extends MemberScope> lazy = $delegateClassScope$delegate;
        return (MemberScope)lazy.getValue();
    }

    private static final boolean checkPropertyInitializer$lambda$36$lambda$34(TypeParameterDescriptor $typeParameter, UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConstructor(), (Object)$typeParameter.getTypeConstructor());
    }

    private static final boolean checkPropertyInitializer$lambda$36$lambda$35(TypeParameterDescriptor $typeParameter, UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConstructor(), (Object)$typeParameter.getTypeConstructor());
    }

    private static final boolean checkPropertyInitializer$lambda$38$lambda$37(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    private static final boolean checkImplicitCallableType$lambda$42$lambda$41(UnwrappedType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return type2.getConstructor() instanceof IntersectionTypeConstructor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u001cH\u0002J\n\u0010\u001d\u001a\u00020\n*\u00020\u001cR2\u0010\u0010\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "<init>", "()V", "removeDuplicateTypes", "", "conflictingTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "isImplementingMethodOfAny", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAnyInternal", "visitedClasses", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isHidingParentMemberIfPresent", "hasSetterAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasAnyAccessorImplementation", "frontend"})
    @SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1167:1\n1761#2,3:1168\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n*L\n1108#1:1168,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Iterator<KotlinType> iterator3 = conflictingTypes.iterator();
                while (iterator3.hasNext()) {
                    KotlinType otherType;
                    KotlinType type2;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block4: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtTypeConstraint it = (KtTypeConstraint)element$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!METHOD_OF_ANY_NAMES.contains(member.getName().asString())) {
                return false;
            }
            if (member.getModality() == Modality.ABSTRACT) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration;
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor.getContainingDeclaration(), (String)"getContainingDeclaration(...)");
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual((Object)DescriptorUtils.getFqName(containingDeclaration), (Object)StandardNames.FqNames.any)) {
                    return true;
                }
                Intrinsics.checkNotNull((Object)callableMemberDescriptor);
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor)) continue;
                visitedClasses.add((ClassDescriptor)containingDeclaration);
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member);
            KtNamedDeclaration ktNamedDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList2 = ktModifierList;
            return !modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        private final boolean hasSetterAccessorImplementation(PropertyDescriptor $this$hasSetterAccessorImplementation) {
            PropertySetterDescriptor propertySetterDescriptor = $this$hasSetterAccessorImplementation.getSetter();
            return propertySetterDescriptor != null ? DescriptorPsiUtilsKt.hasBody(propertySetterDescriptor) : false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasAnyAccessorImplementation(@NotNull PropertyDescriptor $this$hasAnyAccessorImplementation) {
            Intrinsics.checkNotNullParameter((Object)$this$hasAnyAccessorImplementation, (String)"<this>");
            if (this.hasSetterAccessorImplementation($this$hasAnyAccessorImplementation)) return true;
            PropertyGetterDescriptor propertyGetterDescriptor = $this$hasAnyAccessorImplementation.getGetter();
            if (propertyGetterDescriptor == null) return false;
            if (!DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor)) return false;
            return true;
        }

        public static final /* synthetic */ boolean access$hasSetterAccessorImplementation(Companion $this, PropertyDescriptor $receiver) {
            return $this.hasSetterAccessorImplementation($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "wrongNumberOfTypeArguments", "", "typeAlias", "numberOfParameters", "", "conflictingProjection", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "substitutedArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "recursiveTypeAlias", "boundsViolationInSubstitution", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "unsubstitutedArgument", "argument", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "frontend"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final UpperBoundChecker upperBoundChecker;
        @NotNull
        private final KtTypeReference typeReference;

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration, @NotNull UpperBoundChecker upperBoundChecker) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
            this.trace = trace;
            this.upperBoundChecker = upperBoundChecker;
            KtTypeReference ktTypeReference = declaration.getTypeReference();
            if (ktTypeReference == null) {
                throw new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor));
            }
            this.typeReference = ktTypeReference;
        }

        @NotNull
        public final UpperBoundChecker getUpperBoundChecker() {
            return this.upperBoundChecker;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)substitutedArgument, (String)"substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull TypeSubstitutor substitutor2, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
            Intrinsics.checkNotNullParameter((Object)unsubstitutedArgument, (String)"unsubstitutedArgument");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
            UpperBoundChecker.checkBounds$default(this.upperBoundChecker, null, argument, typeParameter, substitutor2, this.trace, this.typeReference, null, 64, null);
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            SourceElement sourceElement = annotation.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            KtAnnotationEntry ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }
}

