/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.binding;

import org.jfaster.mango.util.Objects;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.jdbc.JdbcType;

public class BindingParameter {
    private final String parameterName;
    private final String propertyPath;
    private final JdbcType jdbcType;

    public BindingParameter(String parameterName, String propertyPath, JdbcType jdbcType) {
        this.parameterName = parameterName;
        this.propertyPath = propertyPath;
        this.jdbcType = jdbcType;
    }

    public static BindingParameter create(String parameterName, String propertyPath, JdbcType jdbcType) {
        return new BindingParameter(parameterName, propertyPath, jdbcType);
    }

    public BindingParameter rightShift() {
        String newPropertyPath = Strings.isNotEmpty(this.propertyPath) ? this.parameterName + "." + this.propertyPath : this.parameterName;
        return BindingParameter.create("", newPropertyPath, this.jdbcType);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public String getFullName() {
        return Strings.getFullName(this.parameterName, this.propertyPath);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindingParameter other = (BindingParameter)obj;
        return Objects.equal(this.getParameterName(), other.getParameterName()) && Objects.equal(this.getPropertyPath(), other.getPropertyPath()) && Objects.equal((Object)this.getJdbcType(), (Object)other.getJdbcType());
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.getParameterName(), this.getPropertyPath(), this.getJdbcType()});
    }

    public String toString() {
        return this.getFullName();
    }
}

