/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.binding;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.type.TypeHandlerRegistry;

public class BoundSql {
    private String sql;
    private final List<Object> args;
    private final List<TypeHandler<?>> typeHandlers;

    public BoundSql(String sql) {
        this.sql = sql;
        this.args = new ArrayList<Object>();
        this.typeHandlers = new ArrayList();
    }

    public BoundSql(String sql, List<Object> args, List<TypeHandler<?>> typeHandlers) {
        this.sql = sql;
        this.args = args;
        this.typeHandlers = typeHandlers;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void addArg(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("arg can't be null, if arg is null please use method addNullArg");
        }
        TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(obj.getClass());
        this.args.add(obj);
        this.typeHandlers.add(typeHandler);
    }

    public void addArg(int index, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("arg can't be null, if arg is null please use method addNullArg");
        }
        TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(obj.getClass());
        this.args.add(index, obj);
        this.typeHandlers.add(index, typeHandler);
    }

    public void addNullArg(Class<?> type) {
        TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(type);
        this.args.add(null);
        this.typeHandlers.add(typeHandler);
    }

    public void addNullArg(int index, Class<?> type) {
        TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(type);
        this.args.add(index, null);
        this.typeHandlers.add(index, typeHandler);
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public List<TypeHandler<?>> getTypeHandlers() {
        return this.typeHandlers;
    }

    public BoundSql copy() {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object arg : this.getArgs()) {
            args.add(arg);
        }
        ArrayList typeHandlers = new ArrayList();
        for (TypeHandler<?> typeHandler : this.getTypeHandlers()) {
            typeHandlers.add(typeHandler);
        }
        return new BoundSql(this.getSql(), args, typeHandlers);
    }
}

