/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.binding.BindingException;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.util.Strings;

public class DefaultInvocationContext
implements InvocationContext {
    private final Map<String, Object> parameterNameToValueMap = new LinkedHashMap<String, Object>();
    private final List<Object> parameterValues = new LinkedList<Object>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> args = new LinkedList<Object>();
    private final List<TypeHandler<?>> typeHandlers = new LinkedList();
    private String globalTable;

    private DefaultInvocationContext() {
    }

    public static DefaultInvocationContext create() {
        return new DefaultInvocationContext();
    }

    @Override
    public void addParameter(String parameterName, Object parameterValue) {
        this.parameterNameToValueMap.put(parameterName, parameterValue);
        this.parameterValues.add(parameterValue);
    }

    @Override
    public Object getBindingValue(BindingParameterInvoker invoker) {
        Object value = this.getNullableBindingValue(invoker);
        if (value == null) {
            throw new BindingException("Parameter '" + invoker.getBindingParameter() + "' need a non-null value");
        }
        return value;
    }

    @Override
    @Nullable
    public Object getNullableBindingValue(BindingParameterInvoker invoker) {
        String key = this.getCacheKey(invoker);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        String parameterName = invoker.getBindingParameter().getParameterName();
        if (!this.parameterNameToValueMap.containsKey(parameterName)) {
            throw new BindingException("Parameter '" + BindingParameter.create(parameterName, "", null) + "' not found, available root parameters are " + this.transToBindingParameters(this.parameterNameToValueMap.keySet()));
        }
        Object obj = this.parameterNameToValueMap.get(parameterName);
        Object value = invoker.invoke(obj);
        this.cache.put(key, value);
        return value;
    }

    @Override
    public void setBindingValue(BindingParameterInvoker invoker, Object value) {
        String key = this.getCacheKey(invoker);
        this.cache.put(key, value);
    }

    @Override
    @Nullable
    public String getGlobalTable() {
        return this.globalTable;
    }

    @Override
    public void setGlobalTable(String globalTable) {
        this.globalTable = globalTable;
    }

    @Override
    public void trim(String str) {
        if (Strings.isEmpty(str)) {
            return;
        }
        int start = this.sql.lastIndexOf(str);
        if (start == -1) {
            return;
        }
        int end = this.sql.length();
        boolean needTrim = true;
        for (int i = start + str.length(); i < end; ++i) {
            if (this.sql.charAt(i) == ' ') continue;
            needTrim = false;
            break;
        }
        if (needTrim) {
            this.sql.delete(start, end);
        }
    }

    @Override
    public void writeToSqlBuffer(String str) {
        this.sql.append(str);
    }

    @Override
    public void appendToArgs(Object obj, TypeHandler<?> typeHandler) {
        this.args.add(obj);
        this.typeHandlers.add(typeHandler);
    }

    @Override
    public BoundSql getBoundSql() {
        return new BoundSql(this.sql.toString(), this.args, this.typeHandlers);
    }

    @Override
    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    private String getCacheKey(BindingParameterInvoker invoker) {
        return invoker.getBindingParameter().getFullName();
    }

    private Set<BindingParameter> transToBindingParameters(Collection<String> parameterNames) {
        LinkedHashSet<BindingParameter> rs = new LinkedHashSet<BindingParameter>();
        for (String parameterName : parameterNames) {
            rs.add(BindingParameter.create(parameterName, "", null));
        }
        return rs;
    }
}

