/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.binding;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Rename;
import org.jfaster.mango.binding.BindingException;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.FunctionalBindingParameterInvoker;
import org.jfaster.mango.binding.ParameterContext;
import org.jfaster.mango.descriptor.ParameterDescriptor;

public class DefaultParameterContext
implements ParameterContext {
    private final Map<Integer, String> positionToNameMap = new HashMap<Integer, String>();
    private final Map<String, Type> nameToTypeMap = new LinkedHashMap<String, Type>();
    private final List<ParameterDescriptor> parameterDescriptors = new ArrayList<ParameterDescriptor>();

    private DefaultParameterContext(List<ParameterDescriptor> parameterDescriptors) {
        for (int i = 0; i < parameterDescriptors.size(); ++i) {
            ParameterDescriptor pd = parameterDescriptors.get(i);
            Rename renameAnno = pd.getAnnotation(Rename.class);
            String parameterName = renameAnno != null ? renameAnno.value() : pd.getName();
            this.nameToTypeMap.put(parameterName, pd.getType());
            int position = pd.getPosition();
            this.positionToNameMap.put(position, parameterName);
            this.parameterDescriptors.add(pd);
        }
    }

    public static DefaultParameterContext create(List<ParameterDescriptor> parameterDescriptors) {
        return new DefaultParameterContext(parameterDescriptors);
    }

    @Override
    public String getParameterNameByPosition(int position) {
        String name = this.positionToNameMap.get(position);
        if (name == null) {
            throw new IllegalStateException("parameter name can not be found by position [" + position + "]");
        }
        return name;
    }

    @Override
    public BindingParameterInvoker getBindingParameterInvoker(BindingParameter bindingParameter) {
        String parameterName = bindingParameter.getParameterName();
        Type type = this.nameToTypeMap.get(parameterName);
        if (type == null) {
            throw new BindingException("Parameter '" + BindingParameter.create(bindingParameter.getParameterName(), "", null) + "' not found, available root parameters are " + this.transToBindingParameters(this.nameToTypeMap.keySet()));
        }
        return FunctionalBindingParameterInvoker.create(type, bindingParameter);
    }

    @Override
    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    @Override
    @Nullable
    public BindingParameter tryExpandBindingParameter(BindingParameter bindingParameter) {
        if (!this.nameToTypeMap.containsKey(bindingParameter.getParameterName())) {
            BindingParameter newBindingParameter = bindingParameter.rightShift();
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (Map.Entry<String, Type> entry : this.nameToTypeMap.entrySet()) {
                Type type = entry.getValue();
                try {
                    FunctionalBindingParameterInvoker.create(type, newBindingParameter);
                }
                catch (BindingException e) {
                    continue;
                }
                parameterNames.add(entry.getKey());
            }
            int num = parameterNames.size();
            if (num > 0) {
                if (num != 1) {
                    throw new BindingException("Root parameters " + this.transToBindingParameters(parameterNames) + " has the same property '" + newBindingParameter.getPropertyPath() + "', so can't auto expand");
                }
                return BindingParameter.create((String)parameterNames.get(0), newBindingParameter.getPropertyPath(), newBindingParameter.getJdbcType());
            }
        }
        return null;
    }

    private Set<BindingParameter> transToBindingParameters(Collection<String> parameterNames) {
        LinkedHashSet<BindingParameter> rs = new LinkedHashSet<BindingParameter>();
        for (String parameterName : parameterNames) {
            rs.add(BindingParameter.create(parameterName, "", null));
        }
        return rs;
    }
}

