/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.binding;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.binding.BindingException;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.invoker.UnreachablePropertyException;
import org.jfaster.mango.util.NestedProperty;
import org.jfaster.mango.util.PropertyTokenizer;
import org.jfaster.mango.util.reflect.TypeToken;

public class FunctionalBindingParameterInvoker
implements BindingParameterInvoker {
    private final Type targetType;
    private final BindingParameter bindingParameter;
    private final List<GetterInvoker> invokers;

    private FunctionalBindingParameterInvoker(Type originalType, BindingParameter bindingParameter) {
        this.bindingParameter = bindingParameter;
        this.invokers = new ArrayList<GetterInvoker>();
        Type currentType = originalType;
        Class<?> rawType = TypeToken.of(currentType).getRawType();
        PropertyTokenizer prop = new PropertyTokenizer(bindingParameter.getPropertyPath());
        while (prop.hasCurrent()) {
            String propertyName = prop.getName();
            GetterInvoker invoker = InvokerCache.getGetterInvoker(rawType, propertyName);
            this.invokers.add(invoker);
            currentType = invoker.getReturnType();
            rawType = TypeToken.of(currentType).getRawType();
            prop = prop.next();
        }
        this.targetType = currentType;
    }

    public static FunctionalBindingParameterInvoker create(Type originalType, BindingParameter bindingParameter) {
        try {
            FunctionalBindingParameterInvoker invokerGroup = new FunctionalBindingParameterInvoker(originalType, bindingParameter);
            return invokerGroup;
        }
        catch (UnreachablePropertyException e) {
            throw new BindingException("Parameter '" + bindingParameter + "' can't be readable", e);
        }
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public Object invoke(Object obj) {
        Object r = obj;
        int size = this.invokers.size();
        for (int i = 0; i < size; ++i) {
            if (r == null) {
                NestedProperty np = new NestedProperty();
                for (int j = 0; j < i; ++j) {
                    np.append(this.invokers.get(j).getName());
                }
                BindingParameter bp = BindingParameter.create(this.bindingParameter.getParameterName(), np.getNestedProperty(), null);
                throw new BindingException("Parameter '" + bp + "' is null");
            }
            r = this.invokers.get(i).invoke(r);
        }
        return r;
    }

    @Override
    public BindingParameter getBindingParameter() {
        return this.bindingParameter;
    }
}

