/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.crud.Builder;
import org.jfaster.mango.descriptor.Generic;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.util.reflect.TokenTuple;
import org.jfaster.mango.util.reflect.TypeToken;

public abstract class BuilderFactory {
    @Nullable
    public Builder tryGetBuilder(MethodDescriptor md) {
        String name = md.getName();
        Class<?> daoClass = md.getDaoClass();
        if (TypeToken.of(Generic.class).isAssignableFrom(daoClass)) {
            TypeToken<Generic> daoToken = TypeToken.of(daoClass);
            TokenTuple tuple = daoToken.resolveFatherClassTuple(Generic.class);
            Class<?> entityClass = tuple.getFirst().getRawType();
            Class<?> idClass = tuple.getSecond().getRawType();
            ArrayList<Type> types = new ArrayList<Type>();
            for (ParameterDescriptor pd : md.getParameterDescriptors()) {
                types.add(pd.getType());
            }
            return this.doTryGetBuilder(name, md.getReturnType(), types, entityClass, idClass);
        }
        return null;
    }

    @Nullable
    public abstract Builder doTryGetBuilder(String var1, Type var2, List<Type> var3, Class<?> var4, Class<?> var5);
}

