/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Column;
import org.jfaster.mango.annotation.ID;
import org.jfaster.mango.annotation.Ignore;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.bean.BeanUtil;
import org.jfaster.mango.util.bean.PropertyMeta;

public class CrudMeta {
    private final List<String> properties;
    private final List<String> columns;
    private final Map<String, String> propertyToColumnMap;
    private final Map<String, Type> propertyToTypeMap;
    private final String propertyId;
    private final String columnId;
    private final boolean isAutoGenerateId;

    public CrudMeta(Class<?> clazz) {
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<String> cols = new ArrayList<String>();
        HashMap<String, String> propToColMap = new HashMap<String, String>();
        HashMap<String, Type> propToTypeMap = new HashMap<String, Type>();
        String propId = null;
        String colId = null;
        Boolean autoGenerateId = null;
        for (PropertyMeta propertyMeta : BeanUtil.fetchPropertyMetas(clazz)) {
            Ignore igAnno = propertyMeta.getPropertyAnno(Ignore.class);
            if (igAnno != null) continue;
            String prop = propertyMeta.getName();
            Column colAnno = propertyMeta.getPropertyAnno(Column.class);
            String col = colAnno != null ? colAnno.value() : Strings.underscoreName(prop);
            props.add(prop);
            cols.add(col);
            propToColMap.put(prop, col);
            propToTypeMap.put(prop, propertyMeta.getType());
            ID idAnno = propertyMeta.getPropertyAnno(ID.class);
            if (idAnno == null) continue;
            if (propId != null || colId != null) {
                throw new IllegalStateException("duplicate ID annotation");
            }
            propId = prop;
            colId = col;
            autoGenerateId = idAnno.autoGenerateId();
        }
        if (autoGenerateId == null) {
            throw new IllegalStateException("need ID annotation on field to indicate primary key");
        }
        this.properties = Collections.unmodifiableList(props);
        this.columns = Collections.unmodifiableList(cols);
        this.propertyToColumnMap = Collections.unmodifiableMap(propToColMap);
        this.propertyToTypeMap = Collections.unmodifiableMap(propToTypeMap);
        this.propertyId = propId;
        this.columnId = colId;
        this.isAutoGenerateId = autoGenerateId;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    @Nullable
    public String getColumnByProperty(String property) {
        return this.propertyToColumnMap.get(property);
    }

    @Nullable
    public Type getTypeByProperty(String property) {
        return this.propertyToTypeMap.get(property);
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public boolean isAutoGenerateId() {
        return this.isAutoGenerateId;
    }
}

