/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.crud.Builder;
import org.jfaster.mango.crud.BuilderFactory;
import org.jfaster.mango.crud.CrudException;
import org.jfaster.mango.crud.common.factory.CommonAddAndReturnGeneratedIdBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonAddBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonBatchAddBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonBatchUpdateBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonCountBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonDeleteBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonGetAllBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonGetMultiBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonGetOneBuilderFactory;
import org.jfaster.mango.crud.common.factory.CommonUpdateBuilderFactory;
import org.jfaster.mango.crud.custom.factory.CustomCountBuilderFactory;
import org.jfaster.mango.crud.custom.factory.CustomDeleteBuilderFactory;
import org.jfaster.mango.crud.custom.factory.CustomQueryBuilderFactory;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.SqlGenerator;

public class CrudSqlGenerator
implements SqlGenerator {
    private static final List<BuilderFactory> commonBuilderFactories = new ArrayList<BuilderFactory>();
    private static final List<BuilderFactory> customBuilderFactories = new ArrayList<BuilderFactory>();

    @Override
    public String generateSql(MethodDescriptor md) {
        return this.getBuilder(md).buildSql();
    }

    private Builder getBuilder(MethodDescriptor md) {
        Builder builder;
        for (BuilderFactory commonBuilderFactory : commonBuilderFactories) {
            builder = commonBuilderFactory.tryGetBuilder(md);
            if (builder == null) continue;
            return builder;
        }
        for (BuilderFactory lookupBuilderFactory : customBuilderFactories) {
            builder = lookupBuilderFactory.tryGetBuilder(md);
            if (builder == null) continue;
            return builder;
        }
        throw new CrudException("can't convert method [" + md.getName() + "] to SQL");
    }

    static {
        commonBuilderFactories.add(new CommonAddBuilderFactory());
        commonBuilderFactories.add(new CommonAddAndReturnGeneratedIdBuilderFactory());
        commonBuilderFactories.add(new CommonBatchAddBuilderFactory());
        commonBuilderFactories.add(new CommonGetOneBuilderFactory());
        commonBuilderFactories.add(new CommonGetMultiBuilderFactory());
        commonBuilderFactories.add(new CommonGetAllBuilderFactory());
        commonBuilderFactories.add(new CommonCountBuilderFactory());
        commonBuilderFactories.add(new CommonUpdateBuilderFactory());
        commonBuilderFactories.add(new CommonBatchUpdateBuilderFactory());
        commonBuilderFactories.add(new CommonDeleteBuilderFactory());
        customBuilderFactories.add(new CustomQueryBuilderFactory());
        customBuilderFactories.add(new CustomCountBuilderFactory());
        customBuilderFactories.add(new CustomDeleteBuilderFactory());
    }
}

