/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.common.builder;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.crud.common.builder.AbstractCommonBuilder;
import org.jfaster.mango.util.Joiner;

public class CommonAddBuilder
extends AbstractCommonBuilder {
    private static final String SQL_TEMPLATE = "insert into #table(%s) values(%s)";
    private final List<String> properties;
    private final List<String> columns;

    public CommonAddBuilder(String propId, List<String> props, List<String> cols, boolean isAutoGenerateId) {
        int index = props.indexOf(propId);
        if (index < 0) {
            throw new IllegalArgumentException("error property id [" + propId + "]");
        }
        this.properties = new ArrayList<String>(props);
        this.columns = new ArrayList<String>(cols);
        if (isAutoGenerateId) {
            this.properties.remove(index);
            this.columns.remove(index);
        }
    }

    @Override
    public String buildSql() {
        String s1 = Joiner.on(", ").join(this.columns);
        ArrayList<String> cps = new ArrayList<String>();
        for (String prop : this.properties) {
            cps.add(":" + prop);
        }
        String s2 = Joiner.on(", ").join(cps);
        return String.format(SQL_TEMPLATE, s1, s2);
    }
}

