/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.common.builder;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.crud.common.builder.AbstractCommonBuilder;
import org.jfaster.mango.util.Joiner;

public class CommonGetBuilder
extends AbstractCommonBuilder {
    private static final String SQL_TEMPLATE = "select %s from #table where %s = :1";
    private static final String BATCH_SQL_TEMPLATE = "select %s from #table where %s in (:1)";
    private final String columnId;
    private final List<String> columns;
    private final boolean isBatch;

    public CommonGetBuilder(String colId, List<String> cols, boolean isBatch) {
        int index = cols.indexOf(colId);
        if (index < 0) {
            throw new IllegalArgumentException("error column id [" + colId + "]");
        }
        this.columnId = colId;
        this.columns = new ArrayList<String>(cols);
        this.isBatch = isBatch;
    }

    @Override
    public String buildSql() {
        String s1 = Joiner.on(", ").join(this.columns);
        return this.isBatch ? String.format(BATCH_SQL_TEMPLATE, s1, this.columnId) : String.format(SQL_TEMPLATE, s1, this.columnId);
    }
}

