/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.common.builder;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.crud.common.builder.AbstractCommonBuilder;

public class CommonUpdateBuilder
extends AbstractCommonBuilder {
    private static final String SQL_TEMPLATE = "update #table set %s where %s";
    private final String propertyId;
    private final String columnId;
    private final List<String> properties;
    private final List<String> columns;

    public CommonUpdateBuilder(String propId, List<String> props, List<String> cols) {
        int index = props.indexOf(propId);
        if (index < 0) {
            throw new IllegalArgumentException("error property id [" + propId + "]");
        }
        this.propertyId = propId;
        this.properties = new ArrayList<String>(props);
        this.columns = new ArrayList<String>(cols);
        this.columnId = this.columns.remove(index);
        this.properties.remove(index);
    }

    @Override
    public String buildSql() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.properties.size(); ++i) {
            String prop = ":" + this.properties.get(i);
            String col = this.columns.get(i);
            sb.append(String.format("#if (%s != null) %s = %s,#end ", prop, col, prop));
        }
        sb.append("#trim_comma");
        String str = this.columnId + " = :" + this.propertyId;
        return String.format(SQL_TEMPLATE, sb.toString(), str);
    }
}

