/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.common.factory;

import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.crud.Builder;
import org.jfaster.mango.crud.BuilderFactory;
import org.jfaster.mango.crud.CrudMeta;
import org.jfaster.mango.crud.common.builder.AbstractCommonBuilder;

public abstract class AbstractCommonBuilderFactory
extends BuilderFactory {
    @Override
    @Nullable
    public Builder doTryGetBuilder(String name, Type returnType, List<Type> parameterTypes, Class<?> entityClass, Class<?> idClass) {
        return this.nameMatched(name) && this.returnTypeMatched(returnType, entityClass) && this.parameterTypesMatched(parameterTypes, entityClass, idClass) ? this.createCommonBuilder(new CrudMeta(entityClass)) : null;
    }

    private boolean nameMatched(String actualName) {
        return this.expectedMethodName().equals(actualName);
    }

    private boolean returnTypeMatched(Type returnType, Class<?> entityClass) {
        return this.expectedReturnType(entityClass).equals(returnType);
    }

    private boolean parameterTypesMatched(List<Type> parameterTypes, Class<?> entityClass, Class<?> idClass) {
        return this.expectedParameterType(entityClass, idClass).equals(parameterTypes);
    }

    abstract String expectedMethodName();

    abstract Type expectedReturnType(Class<?> var1);

    abstract List<Type> expectedParameterType(Class<?> var1, Class<?> var2);

    abstract AbstractCommonBuilder createCommonBuilder(CrudMeta var1);
}

