/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.custom.factory;

import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jfaster.mango.crud.Builder;
import org.jfaster.mango.crud.BuilderFactory;
import org.jfaster.mango.crud.CrudException;
import org.jfaster.mango.crud.CrudMeta;
import org.jfaster.mango.crud.custom.builder.AbstractCustomBuilder;
import org.jfaster.mango.crud.custom.parser.MethodNameInfo;
import org.jfaster.mango.crud.custom.parser.MethodNameParser;
import org.jfaster.mango.crud.custom.parser.OpUnit;
import org.jfaster.mango.crud.custom.parser.OrderType;
import org.jfaster.mango.crud.custom.parser.OrderUnit;
import org.jfaster.mango.crud.custom.parser.op.Op;
import org.jfaster.mango.crud.custom.parser.op.Param1ForCollectionOp;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.reflect.TypeToken;
import org.jfaster.mango.util.reflect.TypeWrapper;
import org.jfaster.mango.util.reflect.Types;

public abstract class AbstractCustomBuilderFactory
extends BuilderFactory {
    @Override
    @Nullable
    public Builder doTryGetBuilder(String name, Type returnType, List<Type> parameterTypes, Class<?> entityClass, Class<?> idClass) {
        int matchSize = this.metchSize(name);
        if (matchSize == 0) {
            return null;
        }
        String str = name.substring(matchSize);
        MethodNameInfo info = MethodNameParser.parse(str);
        return this.createCustomBuilder(name, parameterTypes, entityClass, info);
    }

    public abstract List<String> prefixs();

    abstract AbstractCustomBuilder createCustomBuilder(String var1, List<Type> var2, Class<?> var3, MethodNameInfo var4);

    private int metchSize(String name) {
        for (String prefix : this.prefixs()) {
            if (Strings.isEmpty(prefix)) {
                throw new IllegalStateException("prefix can't be empty");
            }
            Pattern p = Pattern.compile(prefix + "[A-Z]");
            Matcher m = p.matcher(name);
            if (!m.find() || m.start() != 0) continue;
            return prefix.length();
        }
        return 0;
    }

    protected void buildWhereClause(StringBuilder tailOfSql, List<OpUnit> opUnits, List<String> logics, CrudMeta cm, List<Type> parameterTypes, String methodName, Class<?> clazz) {
        if (opUnits.size() == 0) {
            throw new IllegalStateException();
        }
        if (opUnits.size() != logics.size() + 1) {
            throw new IllegalStateException();
        }
        int count = 0;
        for (OpUnit opUnit : opUnits) {
            count += opUnit.getOp().paramCount();
        }
        if (parameterTypes.size() < count) {
            throw new CrudException("the name of method [" + methodName + "] is error, the number of parameters expected greater or equal than " + count + ", but " + parameterTypes.size());
        }
        tailOfSql.append("where ");
        int paramIndex = 1;
        for (int i = 0; i < opUnits.size(); ++i) {
            OpUnit opUnit = opUnits.get(i);
            String property = opUnit.getProperty();
            String column = cm.getColumnByProperty(property);
            Type propertyType = cm.getTypeByProperty(property);
            if (column == null || propertyType == null) {
                throw new CrudException("the name of method [" + methodName + "] is error, property " + property + " can't be found in '" + clazz + "'");
            }
            Op op = opUnit.getOp();
            String[] params = new String[op.paramCount()];
            for (int j = 0; j < params.length; ++j) {
                Type parameterType = parameterTypes.get(paramIndex - 1);
                this.checkType(parameterType, propertyType, paramIndex, methodName, op);
                params[j] = ":" + paramIndex;
                ++paramIndex;
            }
            tailOfSql.append(op.render(column, params));
            if (i == opUnits.size() - 1) continue;
            tailOfSql.append(" ").append(logics.get(i)).append(" ");
        }
    }

    protected void checkType(Type paramType, Type propType, int paramIndex, String methodName, Op op) {
        Class<?> rawPropType = TypeToken.of(propType).getRawType();
        if (!(op instanceof Param1ForCollectionOp)) {
            Class<?> rawParamType = TypeToken.of(paramType).getRawType();
            if (!Types.equals(rawPropType, rawParamType)) {
                throw new CrudException("the type of " + paramIndex + "th parameters of method [" + methodName + "] expected '" + propType + "', but '" + paramType + "'");
            }
        } else {
            TypeWrapper tw = new TypeWrapper(paramType);
            if (!tw.isIterable()) {
                throw new CrudException("the type of " + paramIndex + "th parameters of method [" + methodName + "] expected iterable, but '" + paramType + "'");
            }
            if (!Types.equals(rawPropType, tw.getMappedClass())) {
                throw new CrudException("the type of " + paramIndex + "th parameters of method [" + methodName + "] error");
            }
        }
    }

    protected void buildOrderByClause(StringBuilder tailOfSql, @Nullable OrderUnit orderUnit, CrudMeta cm, String methodName, Class<?> clazz) {
        if (orderUnit != null) {
            String property = orderUnit.getProperty();
            String column = cm.getColumnByProperty(property);
            if (column == null) {
                throw new CrudException("the name of method [" + methodName + "] is error, property " + property + " can't be found in '" + clazz + "'");
            }
            tailOfSql.append(" order by " + column);
            OrderType orderType = orderUnit.getOrderType();
            if (orderType != OrderType.NONE) {
                tailOfSql.append(" " + orderType.toString().toLowerCase());
            }
        }
    }
}

