/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.custom.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jfaster.mango.crud.custom.parser.MethodNameInfo;
import org.jfaster.mango.crud.custom.parser.OpUnit;
import org.jfaster.mango.crud.custom.parser.OrderType;
import org.jfaster.mango.crud.custom.parser.OrderUnit;
import org.jfaster.mango.util.Strings;

public class MethodNameParser {
    private static final String DESC = "Desc";
    private static final String ASC = "Asc";
    private static final String ORDER_BY = "OrderBy";
    private static final String ORDER_BY_REGEX = "OrderBy[A-Z]";
    private static final String LOGIC_REGEX = "((And)|(Or))(?=[A-Z])";

    public static MethodNameInfo parse(String str) {
        OrderUnit ou = MethodNameParser.parseOrderUnit(str);
        if (ou != null) {
            str = str.substring(0, str.length() - ou.getOrderStrSize());
        }
        ArrayList<OpUnit> opUnits = new ArrayList<OpUnit>();
        ArrayList<String> logics = new ArrayList<String>();
        Pattern p = Pattern.compile(LOGIC_REGEX);
        Matcher m = p.matcher(str);
        int index = 0;
        while (m.find()) {
            opUnits.add(OpUnit.create(str.substring(index, m.start())));
            logics.add(Strings.firstLetterToLowerCase(m.group()));
            index = m.end();
        }
        opUnits.add(OpUnit.create(str.substring(index)));
        return new MethodNameInfo(opUnits, logics, ou);
    }

    @Nullable
    static OrderUnit parseOrderUnit(String str) {
        Pattern p = Pattern.compile(ORDER_BY_REGEX);
        Matcher m = p.matcher(str);
        if (m.find()) {
            OrderType orderType;
            String property;
            String tailStr = Strings.firstLetterToLowerCase(str.substring(m.end() - 1));
            int size = ORDER_BY.length() + tailStr.length();
            if (tailStr.endsWith(DESC)) {
                property = tailStr.substring(0, tailStr.length() - DESC.length());
                orderType = OrderType.DESC;
            } else if (tailStr.endsWith(ASC)) {
                property = tailStr.substring(0, tailStr.length() - ASC.length());
                orderType = OrderType.ASC;
            } else {
                property = tailStr;
                orderType = OrderType.NONE;
            }
            return new OrderUnit(property, orderType, size);
        }
        return null;
    }
}

