/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.crud.custom.parser;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.crud.custom.parser.op.BetweenOp;
import org.jfaster.mango.crud.custom.parser.op.EqualsOp;
import org.jfaster.mango.crud.custom.parser.op.FalseOp;
import org.jfaster.mango.crud.custom.parser.op.GreaterThanEqualOp;
import org.jfaster.mango.crud.custom.parser.op.GreaterThanOp;
import org.jfaster.mango.crud.custom.parser.op.InOp;
import org.jfaster.mango.crud.custom.parser.op.IsNullOp;
import org.jfaster.mango.crud.custom.parser.op.LessThanEqualOp;
import org.jfaster.mango.crud.custom.parser.op.LessThanOp;
import org.jfaster.mango.crud.custom.parser.op.NotInOp;
import org.jfaster.mango.crud.custom.parser.op.NotNullOp;
import org.jfaster.mango.crud.custom.parser.op.NotOp;
import org.jfaster.mango.crud.custom.parser.op.Op;
import org.jfaster.mango.crud.custom.parser.op.TrueOp;
import org.jfaster.mango.util.Strings;

public class OpUnit {
    private static final List<Op> OPS = new ArrayList<Op>();
    private final Op op;
    private final String property;

    private OpUnit(String str) {
        for (Op op : OPS) {
            if (!str.endsWith(op.keyword())) continue;
            this.op = op;
            this.property = Strings.firstLetterToLowerCase(str.substring(0, str.length() - op.keyword().length()));
            return;
        }
        this.op = new EqualsOp();
        this.property = Strings.firstLetterToLowerCase(str);
    }

    public static OpUnit create(String str) {
        return new OpUnit(str);
    }

    public Op getOp() {
        return this.op;
    }

    public String getProperty() {
        return this.property;
    }

    static {
        OPS.add(new IsNullOp());
        OPS.add(new NotNullOp());
        OPS.add(new TrueOp());
        OPS.add(new FalseOp());
        OPS.add(new LessThanOp());
        OPS.add(new LessThanEqualOp());
        OPS.add(new GreaterThanOp());
        OPS.add(new GreaterThanEqualOp());
        OPS.add(new NotOp());
        OPS.add(new InOp());
        OPS.add(new NotInOp());
        OPS.add(new BetweenOp());
    }
}

