/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.datasource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.datasource.DataSourceFactory;

public class DataSourceFactoryGroup {
    private Map<String, DataSourceFactory> factoryMap;

    public DataSourceFactoryGroup() {
    }

    public DataSourceFactoryGroup(List<DataSourceFactory> factories) {
        this.factoryMap = new HashMap<String, DataSourceFactory>();
        for (DataSourceFactory factory : factories) {
            this.factoryMap.put(factory.getName(), factory);
        }
    }

    public void addDataSourceFactory(DataSourceFactory dataSourceFactory) {
        if (this.factoryMap == null) {
            this.factoryMap = new HashMap<String, DataSourceFactory>();
        }
        this.factoryMap.put(dataSourceFactory.getName(), dataSourceFactory);
    }

    public DataSource getMasterDataSource(String name) {
        DataSourceFactory factory = this.getDataSourceFactory(name);
        DataSource ds = factory.getMasterDataSource();
        this.checkDataSourceNotNull(ds, name);
        return ds;
    }

    public DataSource getSlaveDataSource(String name, Class<?> daoClass) {
        DataSourceFactory factory = this.getDataSourceFactory(name);
        DataSource ds = factory.getSlaveDataSource(daoClass);
        this.checkDataSourceNotNull(ds, name);
        return ds;
    }

    private DataSourceFactory getDataSourceFactory(String name) {
        DataSourceFactory factory = this.factoryMap.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("can not find the datasource factory by name [" + name + "], available names is " + this.factoryMap.keySet());
        }
        return factory;
    }

    private void checkDataSourceNotNull(DataSource dataSource, String name) {
        if (dataSource == null) {
            throw new IllegalArgumentException("the datasource fetched by datasource factory is null, datasource factory name is [" + name + "]");
        }
    }
}

