/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.CacheIgnored;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.annotation.ReturnGeneratedId;
import org.jfaster.mango.annotation.SQL;
import org.jfaster.mango.annotation.Sharding;
import org.jfaster.mango.annotation.UseSqlGenerator;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.descriptor.ReturnDescriptor;
import org.jfaster.mango.descriptor.SqlGenerator;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;
import org.jfaster.mango.util.reflect.Reflection;

public class MethodDescriptor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MethodDescriptor.class);
    private final String name;
    private final Class<?> daoClass;
    private final ReturnDescriptor returnDescriptor;
    private final List<ParameterDescriptor> parameterDescriptors;
    private String cachedSQL;

    private MethodDescriptor(String name, Class<?> daoClass, ReturnDescriptor returnDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        this.name = name;
        this.daoClass = daoClass;
        this.returnDescriptor = returnDescriptor;
        this.parameterDescriptors = Collections.unmodifiableList(parameterDescriptors);
    }

    public static MethodDescriptor create(String name, Class<?> daoClass, ReturnDescriptor returnDescriptor, List<ParameterDescriptor> parameterDescriptors) {
        return new MethodDescriptor(name, daoClass, returnDescriptor, parameterDescriptors);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getDaoClass() {
        return this.daoClass;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.returnDescriptor.getAnnotation(annotationType);
    }

    public Type getReturnType() {
        return this.returnDescriptor.getType();
    }

    public Class<?> getReturnRawType() {
        return this.returnDescriptor.getRawType();
    }

    public List<Annotation> getAnnotations() {
        return this.returnDescriptor.getAnnotations();
    }

    public ReturnDescriptor getReturnDescriptor() {
        return this.returnDescriptor;
    }

    public List<ParameterDescriptor> getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    public String getSQL() {
        String sql;
        if (this.cachedSQL != null) {
            return this.cachedSQL;
        }
        SQL sqlAnno = this.getAnnotation(SQL.class);
        if (sqlAnno != null) {
            sql = sqlAnno.value();
        } else {
            UseSqlGenerator useSqlGeneratorAnno = this.getAnnotation(UseSqlGenerator.class);
            if (useSqlGeneratorAnno == null) {
                throw new DescriptionException("each method expected one of @SQL or @UseSqlGenerator annotation but not found");
            }
            SqlGenerator sqlGenerator = Reflection.instantiateClass(useSqlGeneratorAnno.value());
            sql = sqlGenerator.generateSql(this);
        }
        if (Strings.isEmpty(sql)) {
            throw new DescriptionException("sql is null or empty");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql);
        }
        this.cachedSQL = sql;
        return this.cachedSQL;
    }

    @Nullable
    public String getGlobalTable() {
        DB dbAnno = this.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new DescriptionException("dao interface expected one @DB annotation but not found");
        }
        String table = null;
        if (Strings.isNotEmpty(dbAnno.table())) {
            table = dbAnno.table();
        }
        return table;
    }

    public String getDataSourceFactoryName() {
        DB dbAnno = this.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new DescriptionException("dao interface expected one @DB annotation but not found");
        }
        return dbAnno.name();
    }

    @Nullable
    public Sharding getShardingAnno() {
        return this.getAnnotation(Sharding.class);
    }

    public boolean isUseCache() {
        CacheIgnored cacheIgnoredAnno = this.getAnnotation(CacheIgnored.class);
        Cache cacheAnno = this.getAnnotation(Cache.class);
        return cacheAnno != null && cacheIgnoredAnno == null;
    }

    public boolean isReturnGeneratedId() {
        return this.isAnnotationPresent(ReturnGeneratedId.class) || this.name != null && this.name.contains("ReturnGeneratedId");
    }
}

