/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jfaster.mango.descriptor.Generic;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.ParamNameResolver;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.descriptor.ReturnDescriptor;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TypeToken;

public class Methods {
    private static final TypeToken<?> genericTypeToken = TypeToken.of(Generic.class);

    public static MethodDescriptor getMethodDescriptor(Class<?> daoClass, Method method, boolean isUseActualParamName) {
        LinkedList<Annotation> mas = new LinkedList<Annotation>();
        for (Annotation a : method.getAnnotations()) {
            mas.add(a);
        }
        for (Annotation a : Reflection.getAnnotations(daoClass)) {
            mas.add(a);
        }
        TypeToken<?> daoTypeToken = TypeToken.of(daoClass);
        Type returnType = Methods.fixAndResolveType(method.getGenericReturnType(), daoTypeToken);
        ReturnDescriptor rd = ReturnDescriptor.create(returnType, mas);
        LinkedList<ParameterDescriptor> pds = new LinkedList<ParameterDescriptor>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = Methods.getParameterNames(method, isUseActualParamName);
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type type = Methods.fixAndResolveType(genericParameterTypes[i], daoTypeToken);
            Annotation[] pas = parameterAnnotations[i];
            String name = names[i];
            pds.add(ParameterDescriptor.create(i, type, Arrays.asList(pas), name));
        }
        return MethodDescriptor.create(method.getName(), daoClass, rd, pds);
    }

    public static List<Method> listMethods(Class<?> clazz) {
        Method[] allMethods = clazz.getMethods();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (Methods.isDefault(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    static Type fixAndResolveType(Type type, TypeToken<?> daoTypeToken) {
        type = Methods.fixTypeInJava6(type);
        return Methods.resolveType(type, daoTypeToken);
    }

    static Type fixTypeInJava6(Type type) {
        GenericArrayType gat;
        Type componentType;
        if (type instanceof GenericArrayType && (componentType = (gat = (GenericArrayType)type).getGenericComponentType()) instanceof Class) {
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return type;
    }

    static Type resolveType(Type type, TypeToken<?> daoTypeToken) {
        return genericTypeToken.isAssignableFrom(daoTypeToken) ? daoTypeToken.resolveType(type).getType() : type;
    }

    private static String[] getParameterNames(Method method, boolean isUseActualParamName) {
        String[] names = new String[method.getGenericParameterTypes().length];
        for (int i = 0; i < names.length; ++i) {
            String name = null;
            if (isUseActualParamName) {
                name = ParamNameResolver.getActualParamName(method, i);
            }
            if (name == null) {
                name = String.valueOf(i + 1);
            }
            names[i] = name;
        }
        return names;
    }

    private static boolean isDefault(Method m) {
        return (m.getModifiers() & 0x409) == 1 && m.getDeclaringClass().isInterface();
    }
}

