/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import org.jfaster.mango.util.reflect.TypeToken;
import org.jfaster.mango.util.reflect.TypeWrapper;

public abstract class TypeWithAnnotationDescriptor {
    private final Type type;
    private final Class<?> rawType;
    private final List<Annotation> annotations;
    private final TypeWrapper typeWrapper;

    public TypeWithAnnotationDescriptor(Type type, List<Annotation> annotations) {
        this.type = type;
        this.rawType = TypeToken.of(type).getRawType();
        this.annotations = annotations;
        this.typeWrapper = new TypeWrapper(type);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isArray() {
        return this.typeWrapper.isArray();
    }

    public boolean isCollection() {
        return this.typeWrapper.isCollection();
    }

    public boolean isList() {
        return this.typeWrapper.isList();
    }

    public boolean isArrayList() {
        return this.typeWrapper.isArrayList();
    }

    public boolean isLinkedList() {
        return this.typeWrapper.isLinkedList();
    }

    public boolean isSet() {
        return this.typeWrapper.isSet();
    }

    public boolean isHashSet() {
        return this.typeWrapper.isHashSet();
    }

    public boolean isIterable() {
        return this.typeWrapper.isIterable();
    }

    public boolean isListAssignable() {
        return this.isList() || this.isArrayList() || this.isLinkedList();
    }

    public boolean isSetAssignable() {
        return this.isSet() || this.isHashSet();
    }

    public Class<?> getMappedClass() {
        return this.typeWrapper.getMappedClass();
    }

    public Type getMappedType() {
        return this.typeWrapper.getMappedType();
    }
}

