/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.interceptor;

import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.interceptor.Interceptor;
import org.jfaster.mango.interceptor.Parameter;
import org.jfaster.mango.util.jdbc.SQLType;

public class InterceptorChain {
    private List<Interceptor> interceptors;

    public void addInterceptor(Interceptor interceptor) {
        this.initInterceptorList();
        this.interceptors.add(interceptor);
    }

    public void intercept(BoundSql boundSql, List<Parameter> parameters, SQLType sqlType, DataSource dataSource) {
        if (this.getInterceptors() != null) {
            for (Interceptor interceptor : this.getInterceptors()) {
                interceptor.intercept(boundSql, parameters, sqlType, dataSource);
            }
        }
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    private void initInterceptorList() {
        if (this.interceptors == null) {
            this.interceptors = new LinkedList<Interceptor>();
        }
    }
}

