/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.interceptor;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.interceptor.InterceptorChain;
import org.jfaster.mango.interceptor.Parameter;
import org.jfaster.mango.util.jdbc.SQLType;

public class InvocationInterceptorChain {
    private InterceptorChain interceptorChain;
    private List<ParameterDescriptor> parameterDescriptors;
    private SQLType sqlType;

    public InvocationInterceptorChain(InterceptorChain interceptorChain, List<ParameterDescriptor> parameterDescriptors, SQLType sqlType) {
        this.interceptorChain = interceptorChain;
        this.parameterDescriptors = parameterDescriptors;
        this.sqlType = sqlType;
    }

    public void intercept(BoundSql boundSql, InvocationContext context, DataSource dataSource) {
        if (this.interceptorChain.getInterceptors() != null) {
            List<Object> parameterValues = context.getParameterValues();
            ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterValues.size());
            for (int i = 0; i < parameterValues.size(); ++i) {
                ParameterDescriptor pd = this.parameterDescriptors.get(i);
                parameters.add(new Parameter(pd, parameterValues.get(i)));
            }
            this.interceptorChain.intercept(boundSql, parameters, this.sqlType, dataSource);
        }
    }
}

