/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jfaster.mango.annotation.Getter;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.invoker.GetterFunction;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.MethodNamedObject;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TokenTuple;
import org.jfaster.mango.util.reflect.TypeToken;

public class FunctionalGetterInvoker
extends MethodNamedObject
implements GetterInvoker {
    private GetterFunction function;
    private Type returnType;
    private Class<?> returnRawType;

    private FunctionalGetterInvoker(String name, Method method) {
        super(name, method);
        Getter getterAnno = method.getAnnotation(Getter.class);
        TypeToken<?> returnToken = TypeToken.of(method.getGenericReturnType());
        if (getterAnno != null) {
            Class<? extends GetterFunction<?, ?>> funcClass = getterAnno.value();
            this.function = Reflection.instantiateClass(funcClass);
            TokenTuple tokenTuple = TypeToken.of(funcClass).resolveFatherClassTuple(GetterFunction.class);
            TypeToken<?> inputToken = tokenTuple.getFirst();
            TypeToken<?> outputToken = tokenTuple.getSecond();
            TypeToken<?> wrapReturnToken = returnToken.wrap();
            if (!inputToken.isAssignableFrom(wrapReturnToken)) {
                throw new ClassCastException("function[" + this.function.getClass() + "] on method[" + method + "] error, function's inputType[" + inputToken.getType() + "] must be assignable from method's returnType[" + returnToken.getType() + "]");
            }
            returnToken = outputToken;
        }
        this.returnType = returnToken.getType();
        this.returnRawType = returnToken.getRawType();
    }

    public static FunctionalGetterInvoker create(String name, Method method) {
        return new FunctionalGetterInvoker(name, method);
    }

    @Override
    public Object invoke(Object obj) {
        try {
            Object r = this.method.invoke(obj, new Object[0]);
            if (this.function != null) {
                r = this.function.apply(r);
            }
            return r;
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<?> getReturnRawType() {
        return this.returnRawType;
    }
}

