/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Setter;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.invoker.DummySetterFunction;
import org.jfaster.mango.invoker.MethodNamedObject;
import org.jfaster.mango.invoker.RuntimeSetterFunction;
import org.jfaster.mango.invoker.SetterFunction;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TokenTuple;
import org.jfaster.mango.util.reflect.TypeToken;
import org.jfaster.mango.util.reflect.Types;

public class FunctionalSetterInvoker
extends MethodNamedObject
implements SetterInvoker {
    private FunctionAdapter functionAdapter;
    private Type parameterType;
    private Class<?> parameterRawType;
    private Type runtimeOutputType;
    private Class<?> runtimeOutputRawType;

    private FunctionalSetterInvoker(String name, Method method) {
        super(name, method);
        TypeToken<?> parameterToken = TypeToken.of(method.getGenericParameterTypes()[0]);
        this.runtimeOutputType = parameterToken.getType();
        this.runtimeOutputRawType = parameterToken.getRawType();
        Setter setterAnno = method.getAnnotation(Setter.class);
        if (setterAnno != null) {
            Class<? extends DummySetterFunction<?, ?>> funcClass = setterAnno.value();
            if (SetterFunction.class.isAssignableFrom(funcClass)) {
                this.functionAdapter = new SetterFunctionAdapter((SetterFunction)Reflection.instantiateClass(funcClass));
            } else if (RuntimeSetterFunction.class.isAssignableFrom(funcClass)) {
                this.functionAdapter = new RuntimeSetterFunctionAdapter((RuntimeSetterFunction)Reflection.instantiateClass(funcClass));
            } else {
                throw new IllegalArgumentException("error func class '" + funcClass + "'");
            }
            TokenTuple tokenTuple = TypeToken.of(funcClass).resolveFatherClassTuple(DummySetterFunction.class);
            TypeToken<?> inputToken = tokenTuple.getFirst();
            TypeToken<?> outputToken = tokenTuple.getSecond();
            TypeToken<?> wrapParameterToken = parameterToken.wrap();
            if (this.functionAdapter instanceof RuntimeSetterFunctionAdapter) {
                if (!outputToken.isAssignableFrom(wrapParameterToken)) {
                    throw new ClassCastException("function[" + this.functionAdapter.getFunction().getClass() + "] on method[" + method + "] error, function's outputType[" + outputToken.getType() + "] must be assignable from method's parameterType[" + parameterToken.getType() + "]");
                }
            } else if (!wrapParameterToken.isAssignableFrom(outputToken)) {
                throw new ClassCastException("function[" + this.functionAdapter.getFunction().getClass() + "] on method[" + method + "] error, method's parameterType[" + parameterToken.getType() + "] must be assignable from function's outputType[" + outputToken.getType() + "]");
            }
            parameterToken = inputToken;
        }
        this.parameterType = parameterToken.getType();
        this.parameterRawType = parameterToken.getRawType();
    }

    public static FunctionalSetterInvoker create(String name, Method method) {
        return new FunctionalSetterInvoker(name, method);
    }

    @Override
    public void invoke(Object object, @Nullable Object parameter) {
        try {
            if (this.functionAdapter != null) {
                parameter = this.functionAdapter.apply(parameter, this.runtimeOutputType);
            }
            if (parameter == null && this.runtimeOutputRawType.isPrimitive()) {
                throw new NullPointerException("property " + this.getName() + " of " + object.getClass() + " is primitive, can not be assigned to null");
            }
            if (parameter != null && !Types.isAssignable(this.runtimeOutputRawType, parameter.getClass())) {
                throw new ClassCastException("cannot convert value of type [" + parameter.getClass().getName() + "] to required type [" + this.runtimeOutputRawType.getName() + "] for property '" + this.getName() + "' of " + object.getClass());
            }
            this.method.invoke(object, parameter);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new UncheckedException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Type getParameterType() {
        return this.parameterType;
    }

    @Override
    public Class<?> getParameterRawType() {
        return this.parameterRawType;
    }

    static class RuntimeSetterFunctionAdapter
    implements FunctionAdapter {
        private final RuntimeSetterFunction function;

        RuntimeSetterFunctionAdapter(RuntimeSetterFunction function) {
            this.function = function;
        }

        @Override
        @Nullable
        public Object apply(@Nullable Object input, Type runtimeOutputType) {
            return this.function.apply(input, runtimeOutputType);
        }

        @Override
        public DummySetterFunction getFunction() {
            return this.function;
        }
    }

    static class SetterFunctionAdapter
    implements FunctionAdapter {
        private final SetterFunction function;

        SetterFunctionAdapter(SetterFunction function) {
            this.function = function;
        }

        @Override
        @Nullable
        public Object apply(@Nullable Object input, Type runtimeOutputType) {
            return this.function.apply(input);
        }

        @Override
        public DummySetterFunction getFunction() {
            return this.function;
        }
    }

    static interface FunctionAdapter {
        @Nullable
        public Object apply(@Nullable Object var1, Type var2);

        public DummySetterFunction getFunction();
    }
}

