/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.invoker.FunctionalGetterInvoker;
import org.jfaster.mango.invoker.FunctionalSetterInvoker;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.invoker.UnreachablePropertyException;
import org.jfaster.mango.util.bean.BeanUtil;
import org.jfaster.mango.util.bean.PropertyMeta;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.DoubleCheckCache;
import org.jfaster.mango.util.local.LoadingCache;

public class InvokerCache {
    private static final LoadingCache<Class<?>, InvokerInfo> cache = new DoubleCheckCache(new CacheLoader<Class<?>, InvokerInfo>(){

        @Override
        public InvokerInfo load(Class<?> clazz) {
            try {
                return new InvokerInfo(clazz);
            }
            catch (Exception e) {
                throw new UncheckedException(e.getMessage(), e);
            }
        }
    });

    @Nullable
    public static GetterInvoker getNullableGetterInvoker(Class<?> clazz, String propertyName) {
        return cache.get(clazz).getGetterInvoker(propertyName);
    }

    public static GetterInvoker getGetterInvoker(Class<?> clazz, String propertyName) {
        GetterInvoker invoker = InvokerCache.getNullableGetterInvoker(clazz, propertyName);
        if (invoker == null) {
            throw new UnreachablePropertyException("There is no getter/setter for property named '" + propertyName + "' in '" + clazz + "'");
        }
        return invoker;
    }

    public static List<GetterInvoker> getGetterInvokers(Class<?> clazz) {
        return InvokerCache.cache.get(clazz).getGetterInvokers();
    }

    @Nullable
    public static SetterInvoker getNullableSetterInvoker(Class<?> clazz, String propertyName) {
        return cache.get(clazz).getSetterInvoker(propertyName);
    }

    public static SetterInvoker getSetterInvoker(Class<?> clazz, String propertyName) {
        SetterInvoker invoker = cache.get(clazz).getSetterInvoker(propertyName);
        if (invoker == null) {
            throw new UnreachablePropertyException("There is no getter/setter for property named '" + propertyName + "' in '" + clazz + "'");
        }
        return invoker;
    }

    public static List<SetterInvoker> getSetterInvokers(Class<?> clazz) {
        return InvokerCache.cache.get(clazz).getSetterInvokers();
    }

    private static class InvokerInfo {
        private final Map<String, GetterInvoker> getterInvokerMap;
        private final Map<String, SetterInvoker> setterInvokerMap;
        private final List<GetterInvoker> getterInvokers;
        private final List<SetterInvoker> setterInvokers;

        public InvokerInfo(Class<?> clazz) throws Exception {
            HashMap<String, FunctionalGetterInvoker> gim = new HashMap<String, FunctionalGetterInvoker>();
            HashMap<String, FunctionalSetterInvoker> sim = new HashMap<String, FunctionalSetterInvoker>();
            ArrayList<FunctionalGetterInvoker> gis = new ArrayList<FunctionalGetterInvoker>();
            ArrayList<FunctionalSetterInvoker> sis = new ArrayList<FunctionalSetterInvoker>();
            for (PropertyMeta pm : BeanUtil.fetchPropertyMetas(clazz)) {
                String name = pm.getName();
                Method readMethod = pm.getReadMethod();
                Method writeMethod = pm.getWriteMethod();
                FunctionalGetterInvoker fgi = FunctionalGetterInvoker.create(name, readMethod);
                gim.put(name, fgi);
                gis.add(fgi);
                FunctionalSetterInvoker fsi = FunctionalSetterInvoker.create(name, writeMethod);
                sim.put(name, fsi);
                sis.add(fsi);
            }
            this.getterInvokerMap = Collections.unmodifiableMap(gim);
            this.setterInvokerMap = Collections.unmodifiableMap(sim);
            this.getterInvokers = Collections.unmodifiableList(gis);
            this.setterInvokers = Collections.unmodifiableList(sis);
        }

        GetterInvoker getGetterInvoker(String propertyName) {
            return this.getterInvokerMap.get(propertyName);
        }

        SetterInvoker getSetterInvoker(String propertyName) {
            return this.setterInvokerMap.get(propertyName);
        }

        private List<GetterInvoker> getGetterInvokers() {
            return this.getterInvokers;
        }

        private List<SetterInvoker> getSetterInvokers() {
            return this.setterInvokers;
        }

        private static boolean isBoolean(Class<?> clazz) {
            return Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
        }
    }
}

