/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.invoker.function.enums;

import java.lang.reflect.Type;
import java.util.EnumSet;
import javax.annotation.Nullable;
import org.jfaster.mango.invoker.RuntimeSetterFunction;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.DoubleCheckCache;
import org.jfaster.mango.util.local.LoadingCache;
import org.jfaster.mango.util.reflect.TypeToken;

public class IntegerToEnumFunction
implements RuntimeSetterFunction<Integer, Enum> {
    private static final LoadingCache<Class, EnumSet> cache = new DoubleCheckCache<Class, EnumSet>(new CacheLoader<Class, EnumSet>(){

        @Override
        public EnumSet load(Class enumType) {
            return EnumSet.allOf(enumType);
        }
    });

    @Override
    @Nullable
    public Enum apply(@Nullable Integer input, Type runtimeOutputType) {
        if (input == null) {
            return null;
        }
        Class<?> rawType = TypeToken.of(runtimeOutputType).getRawType();
        EnumSet es = cache.get(rawType);
        for (Enum e : es) {
            if (e.ordinal() != input.intValue()) continue;
            return e;
        }
        throw new IllegalStateException("cant' trans Integer(" + input + ") to " + runtimeOutputType);
    }
}

