/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.jdbc.ArrayResultSetExtractor;
import org.jfaster.mango.jdbc.GeneratedKeyHolder;
import org.jfaster.mango.jdbc.JdbcOperations;
import org.jfaster.mango.jdbc.ListResultSetExtractor;
import org.jfaster.mango.jdbc.ListSupplier;
import org.jfaster.mango.jdbc.ObjectResultSetExtractor;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.jdbc.SQLErrorCodeSQLExceptionTranslator;
import org.jfaster.mango.jdbc.SQLExceptionTranslator;
import org.jfaster.mango.jdbc.SetResultSetExtractor;
import org.jfaster.mango.jdbc.SetSupplier;
import org.jfaster.mango.jdbc.exception.DataAccessException;
import org.jfaster.mango.jdbc.exception.DataRetrievalFailureException;
import org.jfaster.mango.mapper.RowMapper;
import org.jfaster.mango.transaction.DataSourceUtils;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.DoubleCheckCache;
import org.jfaster.mango.util.local.LoadingCache;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class JdbcTemplate
implements JdbcOperations {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdbcTemplate.class);
    private final LoadingCache<DataSource, SQLExceptionTranslator> exceptionTranslatorCache = new DoubleCheckCache<DataSource, SQLExceptionTranslator>(new CacheLoader<DataSource, SQLExceptionTranslator>(){

        @Override
        public SQLExceptionTranslator load(DataSource dataSource) {
            return new SQLErrorCodeSQLExceptionTranslator(dataSource);
        }
    });

    @Override
    public <T> T queryForObject(DataSource dataSource, BoundSql boundSql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(dataSource, boundSql, new ObjectResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(DataSource dataSource, BoundSql boundSql, ListSupplier listSupplier, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.executeQuery(dataSource, boundSql, new ListResultSetExtractor<T>(listSupplier, rowMapper));
    }

    @Override
    public <T> Set<T> queryForSet(DataSource dataSource, BoundSql boundSql, SetSupplier setSupplier, RowMapper<T> rowMapper) throws DataAccessException {
        return (Set)this.executeQuery(dataSource, boundSql, new SetResultSetExtractor<T>(setSupplier, rowMapper));
    }

    @Override
    public <T> Object queryForArray(DataSource dataSource, BoundSql boundSql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.executeQuery(dataSource, boundSql, new ArrayResultSetExtractor<T>(rowMapper));
    }

    @Override
    public int update(DataSource dataSource, BoundSql boundSql) throws DataAccessException {
        return this.update(dataSource, boundSql, null);
    }

    @Override
    public int update(DataSource dataSource, BoundSql boundSql, GeneratedKeyHolder holder) throws DataAccessException {
        int n;
        Connection conn = DataSourceUtils.getConnection(dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = boundSql.getSql();
        try {
            boolean needGenerateKey = holder != null;
            ps = needGenerateKey ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setValues(ps, boundSql);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing \"{}\" {}", (Object)sql, (Object)boundSql.getArgs());
            }
            int r = ps.executeUpdate();
            if (needGenerateKey) {
                rs = ps.getGeneratedKeys();
                if (!rs.next()) {
                    throw new DataRetrievalFailureException("Unable to retrieve the generated key. Check that the table has an identity column enabled.");
                }
                Number key = holder.getTypeHandler().getResult(rs, 1);
                holder.setKey(key);
            }
            n = r;
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (SQLException e) {
            try {
                this.closeResultSet(rs);
                rs = null;
                this.closeStatement(ps);
                ps = null;
                DataSourceUtils.releaseConnection(conn, dataSource);
                conn = null;
                throw this.getExceptionTranslator(dataSource).translate(sql, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                DataSourceUtils.releaseConnection(conn, dataSource);
                throw throwable;
            }
        }
        DataSourceUtils.releaseConnection(conn, dataSource);
        return n;
    }

    @Override
    public int[] batchUpdate(DataSource dataSource, List<BoundSql> boundSqls) throws DataAccessException {
        return this.isUniqueSql(boundSqls) ? this.batchUpdateForUniqueSql(dataSource, boundSqls) : this.batchUpdateForDifferentSql(dataSource, boundSqls);
    }

    private <T> T executeQuery(DataSource dataSource, BoundSql boundSql, ResultSetExtractor<T> rse) throws DataAccessException {
        T t;
        Connection conn = DataSourceUtils.getConnection(dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = boundSql.getSql();
        try {
            ps = conn.prepareStatement(sql);
            this.setValues(ps, boundSql);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing \"{}\" {}", (Object)sql, (Object)boundSql.getArgs());
            }
            rs = ps.executeQuery();
            t = rse.extractData(rs);
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (SQLException e) {
            try {
                this.closeResultSet(rs);
                rs = null;
                this.closeStatement(ps);
                ps = null;
                DataSourceUtils.releaseConnection(conn, dataSource);
                conn = null;
                throw this.getExceptionTranslator(dataSource).translate(sql, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                DataSourceUtils.releaseConnection(conn, dataSource);
                throw throwable;
            }
        }
        DataSourceUtils.releaseConnection(conn, dataSource);
        return t;
    }

    private int[] batchUpdateForUniqueSql(DataSource dataSource, List<BoundSql> boundSqls) throws DataAccessException {
        Connection conn = DataSourceUtils.getConnection(dataSource);
        PreparedStatement ps = null;
        String sql = boundSqls.get(0).getSql();
        try {
            Object debugBatchArgs;
            ps = conn.prepareStatement(sql);
            this.setBatchValues(ps, boundSqls);
            if (logger.isDebugEnabled()) {
                debugBatchArgs = new ArrayList(boundSqls.size());
                for (BoundSql boundSql : boundSqls) {
                    debugBatchArgs.add(boundSql.getArgs());
                }
                logger.debug("Executing \"{}\" {}", (Object)sql, debugBatchArgs);
            }
            debugBatchArgs = ps.executeBatch();
            return debugBatchArgs;
        }
        catch (SQLException e) {
            this.closeStatement(ps);
            ps = null;
            DataSourceUtils.releaseConnection(conn, dataSource);
            conn = null;
            throw this.getExceptionTranslator(dataSource).translate(sql, e);
        }
        finally {
            this.closeStatement(ps);
            DataSourceUtils.releaseConnection(conn, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batchUpdateForDifferentSql(DataSource dataSource, List<BoundSql> boundSqls) throws DataAccessException {
        int size = boundSqls.size();
        int[] r = new int[size];
        Connection conn = DataSourceUtils.getConnection(dataSource);
        try {
            for (int i = 0; i < size; ++i) {
                BoundSql boundSql = boundSqls.get(i);
                String sql = boundSql.getSql();
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement(sql);
                    this.setValues(ps, boundSql);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Executing \"{}\" {}", (Object)sql, (Object)boundSql.getArgs());
                    }
                    r[i] = ps.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    this.closeStatement(ps);
                    ps = null;
                    DataSourceUtils.releaseConnection(conn, dataSource);
                    conn = null;
                    throw this.getExceptionTranslator(dataSource).translate(sql, e);
                }
                finally {
                    this.closeStatement(ps);
                }
            }
        }
        finally {
            DataSourceUtils.releaseConnection(conn, dataSource);
        }
        return r;
    }

    private void setValues(PreparedStatement ps, BoundSql boundSql) throws SQLException {
        List<Object> args = boundSql.getArgs();
        List<TypeHandler<?>> typeHandlers = boundSql.getTypeHandlers();
        for (int i = 0; i < args.size(); ++i) {
            TypeHandler<?> typeHandler = typeHandlers.get(i);
            Object value = args.get(i);
            typeHandler.setParameter(ps, i + 1, value);
        }
    }

    private void setBatchValues(PreparedStatement ps, List<BoundSql> boundSqls) throws SQLException {
        for (BoundSql boundSql : boundSqls) {
            this.setValues(ps, boundSql);
            ps.addBatch();
        }
    }

    boolean isUniqueSql(List<BoundSql> boundSqls) {
        String sql = boundSqls.get(0).getSql();
        boolean r = true;
        for (int i = 1; i < boundSqls.size(); ++i) {
            if (sql.equals(boundSqls.get(i).getSql())) continue;
            r = false;
            break;
        }
        return r;
    }

    private SQLExceptionTranslator getExceptionTranslator(DataSource dataSource) {
        return this.exceptionTranslatorCache.get(dataSource);
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC Statement", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC Statement", e);
            }
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error("Could not close JDBC ResultSet", e);
            }
            catch (Throwable e) {
                logger.error("Unexpected exception on closing JDBC ResultSet", e);
            }
        }
    }
}

