/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jfaster.mango.jdbc.ListSupplier;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.mapper.RowMapper;

public class ListResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final ListSupplier listSupplier;
    private final RowMapper<T> rowMapper;

    public ListResultSetExtractor(ListSupplier listSupplier, RowMapper<T> rowMapper) {
        this.listSupplier = listSupplier;
        this.rowMapper = rowMapper;
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        List<T> results = this.listSupplier.get(this.rowMapper.getMappedClass());
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return results;
    }
}

