/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.mapper.MappingException;
import org.jfaster.mango.mapper.RowMapper;

public class ObjectResultSetExtractor<T>
implements ResultSetExtractor<T> {
    private final RowMapper<T> rowMapper;

    public ObjectResultSetExtractor(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public T extractData(ResultSet rs) throws SQLException {
        Class<T> mappedClass = this.rowMapper.getMappedClass();
        if (!mappedClass.isPrimitive()) {
            return rs.next() ? (T)this.rowMapper.mapRow(rs, 0) : null;
        }
        if (!rs.next()) {
            throw new MappingException("no data, can't cast null to primitive type " + mappedClass);
        }
        T r = this.rowMapper.mapRow(rs, 0);
        if (r == null) {
            throw new MappingException("data is null, can't cast null to primitive type " + mappedClass);
        }
        return r;
    }
}

