/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.jfaster.mango.jdbc.AbstractFallbackSQLExceptionTranslator;
import org.jfaster.mango.jdbc.SQLErrorCodes;
import org.jfaster.mango.jdbc.SQLErrorCodesFactory;
import org.jfaster.mango.jdbc.SQLExceptionSubclassTranslator;
import org.jfaster.mango.jdbc.exception.BadSqlGrammarException;
import org.jfaster.mango.jdbc.exception.CannotAcquireLockException;
import org.jfaster.mango.jdbc.exception.CannotSerializeTransactionException;
import org.jfaster.mango.jdbc.exception.DataAccessException;
import org.jfaster.mango.jdbc.exception.DataAccessResourceFailureException;
import org.jfaster.mango.jdbc.exception.DataIntegrityViolationException;
import org.jfaster.mango.jdbc.exception.DeadlockLoserDataAccessException;
import org.jfaster.mango.jdbc.exception.DuplicateKeyException;
import org.jfaster.mango.jdbc.exception.InvalidResultSetAccessException;
import org.jfaster.mango.jdbc.exception.PermissionDeniedDataAccessException;
import org.jfaster.mango.jdbc.exception.TransientDataAccessResourceException;

public class SQLErrorCodeSQLExceptionTranslator
extends AbstractFallbackSQLExceptionTranslator {
    private final SQLErrorCodes sqlErrorCodes;

    public SQLErrorCodeSQLExceptionTranslator(DataSource dataSource) {
        this.setFallbackTranslator(new SQLExceptionSubclassTranslator());
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(dataSource);
    }

    @Override
    protected DataAccessException doTranslate(String sql, SQLException ex) {
        String errorCode;
        SQLException nestedSqlEx;
        SQLException sqlEx = ex;
        if (sqlEx instanceof BatchUpdateException && sqlEx.getNextException() != null && ((nestedSqlEx = sqlEx.getNextException()).getErrorCode() > 0 || nestedSqlEx.getSQLState() != null)) {
            logger.debug("Using nested SQLException from the BatchUpdateException");
            sqlEx = nestedSqlEx;
        }
        if (this.sqlErrorCodes.isUseSqlStateForTranslation()) {
            errorCode = sqlEx.getSQLState();
        } else {
            SQLException current = sqlEx;
            while (current.getErrorCode() == 0 && current.getCause() instanceof SQLException) {
                current = (SQLException)current.getCause();
            }
            errorCode = Integer.toString(current.getErrorCode());
        }
        if (errorCode != null) {
            if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new BadSqlGrammarException(sql, sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getInvalidResultSetAccessCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new InvalidResultSetAccessException(sql, sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDuplicateKeyCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new DuplicateKeyException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new DataIntegrityViolationException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getPermissionDeniedCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new PermissionDeniedDataAccessException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessResourceFailureException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getTransientDataAccessResourceCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new TransientDataAccessResourceException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getCannotAcquireLockCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new CannotAcquireLockException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getDeadlockLoserCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new DeadlockLoserDataAccessException(this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (Arrays.binarySearch(this.sqlErrorCodes.getCannotSerializeTransactionCodes(), errorCode) >= 0) {
                this.logTranslation(sql, sqlEx);
                return new CannotSerializeTransactionException(this.buildMessage(sql, sqlEx), sqlEx);
            }
        }
        if (logger.isDebugEnabled()) {
            String codes = this.sqlErrorCodes.isUseSqlStateForTranslation() ? "SQL state '" + sqlEx.getSQLState() + "', error code '" + sqlEx.getErrorCode() : "Error code '" + sqlEx.getErrorCode() + "'";
            logger.debug("Unable to translate SQLException with " + codes + ", will now try the fallback translator");
        }
        return null;
    }

    private void logTranslation(String sql, SQLException sqlEx) {
        if (logger.isDebugEnabled()) {
            logger.debug("Translating SQLException with SQL state '" + sqlEx.getSQLState() + "', error code '" + sqlEx.getErrorCode() + "', message [" + sqlEx.getMessage() + "]; SQL was [" + sql + "]");
        }
    }
}

