/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

public enum SQLErrorCodes {
    EMPTY{

        @Override
        void init() {
        }
    }
    ,
    DB2{

        @Override
        void init() {
            this.setDatabaseProductName("DB2*");
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("-007,-029,-097,-104,-109,-115,-128,-199,-204,-206,-301,-408,-441,-491"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("-803"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("-407,-530,-531,-532,-543,-544,-545,-603,-667"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("-904,-971"));
            this.setTransientDataAccessResourceCodes(SQLErrorCodes.parse("-1035,-1218,-30080,-30081"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("-911,-913"));
        }
    }
    ,
    Derby{

        @Override
        void init() {
            this.setDatabaseProductName("Apache Derby");
            this.setUseSqlStateForTranslation(true);
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("42802,42821,42X01,42X02,42X03,42X04,42X05,42X06,42X07,42X08"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("23505"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("22001,22005,23502,23503,23513,X0Y32"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("04501,08004,42Y07"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("40XL1"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("40001"));
        }
    }
    ,
    H2{

        @Override
        void init() {
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("42000,42001,42101,42102,42111,42112,42121,42122,42132"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("23001,23505"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("22001,22003,22012,22018,22025,23000,23002,23003,23502,23503,23506,23507,23513"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("90046,90100,90117,90121,90126"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("50200"));
        }
    }
    ,
    Informix{

        @Override
        void init() {
            this.setDatabaseProductName("Informix Dynamic Server");
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("-201,-217,-696"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("-239,-268,-6017"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("-692,-11030"));
        }
    }
    ,
    MSSQL{

        @Override
        void init() {
            this.setDatabaseProductNames(new String[]{"MS-SQL", "Microsoft SQL Server"});
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("156,170,207,208,209"));
            this.setPermissionDeniedCodes(SQLErrorCodes.parse("229"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("2601,2627"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("544,8114,8115"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("4060"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("1222"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("1205"));
        }
    }
    ,
    HSQL{

        @Override
        void init() {
            this.setDatabaseProductName("HSQL Database Engine");
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("-22,-28"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("-104"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("-9"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("-80"));
        }
    }
    ,
    MySQL{

        @Override
        void init() {
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("1054,1064,1146"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("1062"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("630,839,840,893,1169,1215,1216,1217,1364,1451,1452,1557"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("1"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("1205"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("1213"));
        }
    }
    ,
    Oracle{

        @Override
        void init() {
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("900,903,904,917,936,942,17006,6550"));
            this.setInvalidResultSetAccessCodes(SQLErrorCodes.parse("17003"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("1"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("1400,1722,2291,2292"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("17002,17447"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("54,30006"));
            this.setCannotSerializeTransactionCodes(SQLErrorCodes.parse("8177"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("60"));
        }
    }
    ,
    PostgreSQL{

        @Override
        void init() {
            this.setUseSqlStateForTranslation(true);
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("03000,42000,42601,42602,42622,42804,42P01"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("23505"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("23000,23502,23503,23514"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("53000,53100,53200,53300"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("55P03"));
            this.setCannotSerializeTransactionCodes(SQLErrorCodes.parse("40001"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("40P01"));
        }
    }
    ,
    Sybase{

        @Override
        void init() {
            this.setDatabaseProductNames(new String[]{"Sybase SQL Server", "SQL Server", "Adaptive Server Enterprise", "ASE", "sql server"});
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("101,102,103,104,105,106,107,108,109,110,111,112,113,116,120,121,123,207,208,213,257,512"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("2601,2615,2626"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("233,511,515,530,546,547,2615,2714"));
            this.setTransientDataAccessResourceCodes(SQLErrorCodes.parse("921,1105"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("12205"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("1205"));
        }
    }
    ,
    Hana{

        @Override
        void init() {
            this.setDatabaseProductName("SAP DB");
            this.setBadSqlGrammarCodes(SQLErrorCodes.parse("257,259,260,261,262,263,264,267,268,269,270,271,272,273,275,276,277,278,278,279,280,281,282,283,284,285,286,288,289,290,294,295,296,297,299,308,309,313,315,316,318,319,320,321,322,323,324,328,329,330,333,335,336,337,338,340,343,350,351,352,362,368"));
            this.setPermissionDeniedCodes(SQLErrorCodes.parse("10,258"));
            this.setDuplicateKeyCodes(SQLErrorCodes.parse("301"));
            this.setDataIntegrityViolationCodes(SQLErrorCodes.parse("461,462"));
            this.setDataAccessResourceFailureCodes(SQLErrorCodes.parse("-813,-709,-708,1024,1025,1026,1027,1029,1030,1031"));
            this.setInvalidResultSetAccessCodes(SQLErrorCodes.parse("-11210,582,587,588,594"));
            this.setCannotAcquireLockCodes(SQLErrorCodes.parse("131"));
            this.setCannotSerializeTransactionCodes(SQLErrorCodes.parse("138,143"));
            this.setDeadlockLoserCodes(SQLErrorCodes.parse("133"));
        }
    };

    private String[] databaseProductNames = new String[0];
    private boolean useSqlStateForTranslation = false;
    private String[] badSqlGrammarCodes = new String[0];
    private String[] invalidResultSetAccessCodes = new String[0];
    private String[] duplicateKeyCodes = new String[0];
    private String[] dataIntegrityViolationCodes = new String[0];
    private String[] permissionDeniedCodes = new String[0];
    private String[] dataAccessResourceFailureCodes = new String[0];
    private String[] transientDataAccessResourceCodes = new String[0];
    private String[] cannotAcquireLockCodes = new String[0];
    private String[] deadlockLoserCodes = new String[0];
    private String[] cannotSerializeTransactionCodes = new String[0];

    public String getDatabaseProductName() {
        return this.databaseProductNames != null && this.databaseProductNames.length > 0 ? this.databaseProductNames[0] : null;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductNames = new String[]{databaseProductName};
    }

    public String[] getDatabaseProductNames() {
        return this.databaseProductNames;
    }

    public void setDatabaseProductNames(String[] databaseProductNames) {
        this.databaseProductNames = databaseProductNames;
    }

    public boolean isUseSqlStateForTranslation() {
        return this.useSqlStateForTranslation;
    }

    public void setUseSqlStateForTranslation(boolean useSqlStateForTranslation) {
        this.useSqlStateForTranslation = useSqlStateForTranslation;
    }

    public String[] getBadSqlGrammarCodes() {
        return this.badSqlGrammarCodes;
    }

    public void setBadSqlGrammarCodes(String[] badSqlGrammarCodes) {
        this.badSqlGrammarCodes = badSqlGrammarCodes;
    }

    public String[] getInvalidResultSetAccessCodes() {
        return this.invalidResultSetAccessCodes;
    }

    public void setInvalidResultSetAccessCodes(String[] invalidResultSetAccessCodes) {
        this.invalidResultSetAccessCodes = invalidResultSetAccessCodes;
    }

    public String[] getDuplicateKeyCodes() {
        return this.duplicateKeyCodes;
    }

    public void setDuplicateKeyCodes(String[] duplicateKeyCodes) {
        this.duplicateKeyCodes = duplicateKeyCodes;
    }

    public String[] getDataIntegrityViolationCodes() {
        return this.dataIntegrityViolationCodes;
    }

    public void setDataIntegrityViolationCodes(String[] dataIntegrityViolationCodes) {
        this.dataIntegrityViolationCodes = dataIntegrityViolationCodes;
    }

    public String[] getPermissionDeniedCodes() {
        return this.permissionDeniedCodes;
    }

    public void setPermissionDeniedCodes(String[] permissionDeniedCodes) {
        this.permissionDeniedCodes = permissionDeniedCodes;
    }

    public String[] getDataAccessResourceFailureCodes() {
        return this.dataAccessResourceFailureCodes;
    }

    public void setDataAccessResourceFailureCodes(String[] dataAccessResourceFailureCodes) {
        this.dataAccessResourceFailureCodes = dataAccessResourceFailureCodes;
    }

    public String[] getTransientDataAccessResourceCodes() {
        return this.transientDataAccessResourceCodes;
    }

    public void setTransientDataAccessResourceCodes(String[] transientDataAccessResourceCodes) {
        this.transientDataAccessResourceCodes = transientDataAccessResourceCodes;
    }

    public String[] getCannotAcquireLockCodes() {
        return this.cannotAcquireLockCodes;
    }

    public void setCannotAcquireLockCodes(String[] cannotAcquireLockCodes) {
        this.cannotAcquireLockCodes = cannotAcquireLockCodes;
    }

    public String[] getDeadlockLoserCodes() {
        return this.deadlockLoserCodes;
    }

    public void setDeadlockLoserCodes(String[] deadlockLoserCodes) {
        this.deadlockLoserCodes = deadlockLoserCodes;
    }

    public String[] getCannotSerializeTransactionCodes() {
        return this.cannotSerializeTransactionCodes;
    }

    public void setCannotSerializeTransactionCodes(String[] cannotSerializeTransactionCodes) {
        this.cannotSerializeTransactionCodes = cannotSerializeTransactionCodes;
    }

    abstract void init();

    private static String[] parse(String codes) {
        return codes.split(",");
    }
}

