/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.jdbc.SQLErrorCodes;
import org.jfaster.mango.jdbc.exception.MetaDataAccessException;
import org.jfaster.mango.transaction.DataSourceUtils;
import org.jfaster.mango.transaction.exception.CannotGetJdbcConnectionException;
import org.jfaster.mango.util.PatternMatchUtils;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class SQLErrorCodesFactory {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(SQLErrorCodesFactory.class);
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map<DataSource, SQLErrorCodes> dataSourceCache = new HashMap<DataSource, SQLErrorCodes>(16);
    private final Map<String, SQLErrorCodes> errorCodesMap = this.buildErrorCodesMap();

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]");
        }
        Map<DataSource, SQLErrorCodes> map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = this.dataSourceCache.get(dataSource);
            if (sec != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SQLErrorCodes found in cache for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]");
                }
                return sec;
            }
            try {
                String dbName = this.fetchDatabaseProductName(dataSource);
                if (dbName != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Database product name cached for DataSource [" + dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode()) + "]: name is '" + dbName + "'");
                    }
                    sec = this.getErrorCodes(dbName);
                    this.dataSourceCache.put(dataSource, sec);
                    return sec;
                }
            }
            catch (MetaDataAccessException ex) {
                logger.warn("Error while extracting database product name - falling back to empty error codes", ex);
            }
        }
        return SQLErrorCodes.EMPTY;
    }

    private SQLErrorCodes getErrorCodes(String dbName) {
        SQLErrorCodes sec = this.errorCodesMap.get(dbName);
        if (sec == null) {
            for (SQLErrorCodes candidate : this.errorCodesMap.values()) {
                if (!PatternMatchUtils.simpleMatch(candidate.getDatabaseProductNames(), dbName)) continue;
                sec = candidate;
                break;
            }
        }
        if (sec != null) {
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SQL error codes for '" + dbName + "' not found");
        }
        return SQLErrorCodes.EMPTY;
    }

    private Map<String, SQLErrorCodes> buildErrorCodesMap() {
        HashMap<String, SQLErrorCodes> errorCodesMap = new HashMap<String, SQLErrorCodes>();
        for (SQLErrorCodes errorCodes : SQLErrorCodes.values()) {
            if (errorCodes == SQLErrorCodes.EMPTY) continue;
            errorCodes.init();
            errorCodesMap.put(errorCodes.name(), errorCodes);
        }
        return errorCodesMap;
    }

    private String fetchDatabaseProductName(DataSource dataSource) throws MetaDataAccessException {
        Connection conn = null;
        try {
            conn = DataSourceUtils.getConnection(dataSource);
            DatabaseMetaData metaData = conn.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", ex);
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        finally {
            DataSourceUtils.releaseConnection(conn, dataSource);
        }
    }
}

