/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import org.jfaster.mango.jdbc.AbstractFallbackSQLExceptionTranslator;
import org.jfaster.mango.jdbc.SQLStateSQLExceptionTranslator;
import org.jfaster.mango.jdbc.exception.BadSqlGrammarException;
import org.jfaster.mango.jdbc.exception.ConcurrencyFailureException;
import org.jfaster.mango.jdbc.exception.DataAccessException;
import org.jfaster.mango.jdbc.exception.DataAccessResourceFailureException;
import org.jfaster.mango.jdbc.exception.DataIntegrityViolationException;
import org.jfaster.mango.jdbc.exception.InvalidDataAccessApiUsageException;
import org.jfaster.mango.jdbc.exception.PermissionDeniedDataAccessException;
import org.jfaster.mango.jdbc.exception.QueryTimeoutException;
import org.jfaster.mango.jdbc.exception.RecoverableDataAccessException;
import org.jfaster.mango.jdbc.exception.TransientDataAccessResourceException;

public class SQLExceptionSubclassTranslator
extends AbstractFallbackSQLExceptionTranslator {
    public SQLExceptionSubclassTranslator() {
        this.setFallbackTranslator(new SQLStateSQLExceptionTranslator());
    }

    @Override
    protected DataAccessException doTranslate(String sql, SQLException ex) {
        if (ex instanceof SQLTransientException) {
            if (ex instanceof SQLTransactionRollbackException) {
                return new ConcurrencyFailureException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLTransientConnectionException) {
                return new TransientDataAccessResourceException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLTimeoutException) {
                return new QueryTimeoutException(this.buildMessage(sql, ex), ex);
            }
        } else if (ex instanceof SQLNonTransientException) {
            if (ex instanceof SQLDataException) {
                return new DataIntegrityViolationException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLFeatureNotSupportedException) {
                return new InvalidDataAccessApiUsageException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLIntegrityConstraintViolationException) {
                return new DataIntegrityViolationException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLInvalidAuthorizationSpecException) {
                return new PermissionDeniedDataAccessException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLNonTransientConnectionException) {
                return new DataAccessResourceFailureException(this.buildMessage(sql, ex), ex);
            }
            if (ex instanceof SQLSyntaxErrorException) {
                return new BadSqlGrammarException(sql, ex);
            }
        } else if (ex instanceof SQLRecoverableException) {
            return new RecoverableDataAccessException(this.buildMessage(sql, ex), ex);
        }
        return null;
    }
}

