/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.jfaster.mango.jdbc.ResultSetExtractor;
import org.jfaster.mango.jdbc.SetSupplier;
import org.jfaster.mango.mapper.RowMapper;

public class SetResultSetExtractor<T>
implements ResultSetExtractor<Set<T>> {
    private final SetSupplier setSupplier;
    private final RowMapper<T> rowMapper;

    public SetResultSetExtractor(SetSupplier setSupplier, RowMapper<T> rowMapper) {
        this.setSupplier = setSupplier;
        this.rowMapper = rowMapper;
    }

    @Override
    public Set<T> extractData(ResultSet rs) throws SQLException {
        Set<T> results = this.setSupplier.get(this.rowMapper.getMappedClass());
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.rowMapper.mapRow(rs, rowNum++));
        }
        return results;
    }
}

