/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.invoker.UnreachablePropertyException;
import org.jfaster.mango.mapper.FunctionalSetterInvokerGroup;
import org.jfaster.mango.mapper.MappingException;
import org.jfaster.mango.mapper.RowMapper;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.type.TypeHandlerRegistry;
import org.jfaster.mango.util.PropertyTokenizer;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.jdbc.ResultSetWrapper;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;
import org.jfaster.mango.util.reflect.Reflection;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BeanPropertyRowMapper.class);
    private Class<T> mappedClass;
    private Map<String, SetterInvoker> invokerMap;
    private Map<String, String> columnToPropertyMap;
    private boolean checkColumn;

    public BeanPropertyRowMapper(Class<T> mappedClass, Map<String, String> propertyToColumnMap, boolean checkColumn) {
        this.initialize(mappedClass, propertyToColumnMap, checkColumn);
    }

    protected void initialize(Class<T> mappedClass, Map<String, String> propertyToColumnMap, boolean checkColumn) {
        this.mappedClass = mappedClass;
        this.checkColumn = checkColumn;
        this.columnToPropertyMap = new HashMap<String, String>();
        this.invokerMap = new HashMap<String, SetterInvoker>();
        for (Map.Entry<String, String> entry : propertyToColumnMap.entrySet()) {
            String property = entry.getKey();
            PropertyTokenizer propToken = new PropertyTokenizer(property);
            if (!propToken.hasNext()) continue;
            this.columnToPropertyMap.put(entry.getValue().toLowerCase(), property);
        }
        List<SetterInvoker> invokers = InvokerCache.getSetterInvokers(mappedClass);
        for (SetterInvoker invoker : invokers) {
            String column = propertyToColumnMap.get(invoker.getName());
            if (column != null) {
                this.invokerMap.put(column.toLowerCase(), invoker);
                continue;
            }
            this.invokerMap.put(invoker.getName().toLowerCase(), invoker);
            String underscoredName = Strings.underscoreName(invoker.getName());
            if (invoker.getName().toLowerCase().equals(underscoredName)) continue;
            this.invokerMap.put(underscoredName, invoker);
        }
    }

    @Override
    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        T mappedObject = Reflection.instantiate(this.mappedClass);
        ResultSetWrapper rsw = new ResultSetWrapper(rs);
        int columnCount = rsw.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String columnName = rsw.getColumnName(index);
            String lowerCaseColumnName = columnName.toLowerCase();
            String propertyPath = this.columnToPropertyMap.get(lowerCaseColumnName);
            if (propertyPath != null) {
                this.setValueByPropertyPath(mappedObject, propertyPath, rsw, index, rowNumber);
                continue;
            }
            PropertyTokenizer prop = new PropertyTokenizer(columnName);
            if (prop.hasNext()) {
                this.setValueByPropertyPath(mappedObject, columnName, rsw, index, rowNumber);
                continue;
            }
            this.setValueByProperty(mappedObject, lowerCaseColumnName, rsw, index, rowNumber);
        }
        return mappedObject;
    }

    private void setValueByPropertyPath(Object mappedObject, String propertyPath, ResultSetWrapper rsw, int index, int rowNumber) throws SQLException {
        FunctionalSetterInvokerGroup g;
        block4: {
            g = null;
            try {
                g = FunctionalSetterInvokerGroup.create(this.mappedClass, propertyPath);
            }
            catch (UnreachablePropertyException e) {
                if (!this.checkColumn) break block4;
                throw new MappingException("Unable to map column '" + rsw.getColumnName(index) + "' to property '" + propertyPath + "'");
            }
        }
        if (g != null) {
            TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(g.getTargetType(), rsw.getJdbcType(index));
            Object value = typeHandler.getResult(rsw.getResultSet(), index);
            if (logger.isDebugEnabled() && rowNumber == 0) {
                logger.debug("Mapping column '" + rsw.getColumnName(index) + "' to property '" + propertyPath + "' of type " + g.getTargetType());
            }
            g.invoke(mappedObject, value);
        }
    }

    private void setValueByProperty(Object mappedObject, String lowerCaseColumnName, ResultSetWrapper rsw, int index, int rowNumber) throws SQLException {
        SetterInvoker invoker = this.invokerMap.get(lowerCaseColumnName);
        if (invoker != null) {
            TypeHandler<?> typeHandler = TypeHandlerRegistry.getTypeHandler(invoker.getParameterRawType(), rsw.getJdbcType(index));
            Object value = typeHandler.getResult(rsw.getResultSet(), index);
            if (logger.isDebugEnabled() && rowNumber == 0) {
                logger.debug("Mapping column '" + rsw.getColumnName(index) + "' to property '" + invoker.getName() + "' of type " + invoker.getParameterRawType());
            }
            invoker.invoke(mappedObject, value);
        } else if (this.checkColumn) {
            throw new MappingException("Unable to map column '" + rsw.getColumnName(index) + "' to any property of '" + this.mappedClass + "'");
        }
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }
}

