/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.mapper;

import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.invoker.UnreachablePropertyException;
import org.jfaster.mango.mapper.MetaObject;
import org.jfaster.mango.mapper.SetterInvokerGroup;
import org.jfaster.mango.util.PropertyTokenizer;

public class FunctionalSetterInvokerGroup
implements SetterInvokerGroup {
    private final Class<?> originalType;
    private final String propertyPath;
    private final Class<?> targetType;

    private FunctionalSetterInvokerGroup(Class<?> originalType, String propertyPath) {
        this.originalType = originalType;
        this.propertyPath = propertyPath;
        PropertyTokenizer prop = new PropertyTokenizer(propertyPath);
        if (!prop.hasNext()) {
            throw new IllegalStateException("property path '" + propertyPath + "' error");
        }
        Class<?> currentType = originalType;
        while (prop.hasCurrent()) {
            String propertyName = prop.getName();
            SetterInvoker setter = InvokerCache.getSetterInvoker(currentType, propertyName);
            if (prop.hasNext()) {
                GetterInvoker getter = InvokerCache.getGetterInvoker(currentType, propertyName);
                if (!setter.getParameterType().equals(getter.getReturnType())) {
                    throw new UnreachablePropertyException("Inconsistent setter/getter type for property named '" + propertyName + "' in '" + currentType + "'");
                }
            }
            currentType = setter.getParameterRawType();
            prop = prop.next();
        }
        this.targetType = currentType;
    }

    public static FunctionalSetterInvokerGroup create(Class<?> originalType, String propertyPath) {
        return new FunctionalSetterInvokerGroup(originalType, propertyPath);
    }

    @Override
    public Class<?> getOriginalType() {
        return this.originalType;
    }

    @Override
    public Class<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public void invoke(Object obj, Object value) {
        MetaObject mo = MetaObject.forObject(obj);
        mo.setValue(this.propertyPath, value);
    }
}

