/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.mapper;

import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.invoker.SetterInvoker;
import org.jfaster.mango.mapper.SystemMetaObject;
import org.jfaster.mango.util.PropertyTokenizer;
import org.jfaster.mango.util.reflect.Reflection;

public class MetaObject {
    private Object originalObject;
    private Class<?> originalClass;

    private MetaObject(Object object) {
        this.originalObject = object;
        this.originalClass = object.getClass();
    }

    public static MetaObject forObject(Object object) {
        if (object == null) {
            return SystemMetaObject.NULL_META_OBJECT;
        }
        return new MetaObject(object);
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    private Object getValue(String propertyName) {
        GetterInvoker invoker = InvokerCache.getGetterInvoker(this.originalClass, propertyName);
        return invoker.invoke(this.originalObject);
    }

    public void setValue(String propertyPath, Object value) {
        PropertyTokenizer prop = new PropertyTokenizer(propertyPath);
        if (prop.hasNext()) {
            MetaObject metaValue = this.metaObjectForProperty(prop.getName());
            if (metaValue == SystemMetaObject.NULL_META_OBJECT) {
                if (value == null && prop.getChildren() != null) {
                    return;
                }
                SetterInvoker invoker = InvokerCache.getSetterInvoker(this.originalClass, prop.getName());
                Class<?> clazz = invoker.getParameterRawType();
                Object newObject = Reflection.instantiate(clazz);
                metaValue = MetaObject.forObject(newObject);
                invoker.invoke(this.originalObject, newObject);
            }
            metaValue.setValue(prop.getChildren(), value);
        } else {
            SetterInvoker invoker = InvokerCache.getSetterInvoker(this.originalClass, propertyPath);
            invoker.invoke(this.originalObject, value);
        }
    }

    public MetaObject metaObjectForProperty(String name) {
        Object value = this.getValue(name);
        return MetaObject.forObject(value);
    }
}

