/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jfaster.mango.mapper.RowMapper;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.type.TypeHandlerRegistry;
import org.jfaster.mango.util.jdbc.ResultSetWrapper;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<T> mappedClass;

    public SingleColumnRowMapper(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetWrapper rsw = new ResultSetWrapper(rs);
        int index = 1;
        TypeHandler<T> typeHandler = TypeHandlerRegistry.getTypeHandler(this.mappedClass, rsw.getJdbcType(index));
        T value = typeHandler.getResult(rsw.getResultSet(), index);
        return value;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }
}

