/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import org.jfaster.mango.annotation.UseTransactionForBatchUpdate;
import org.jfaster.mango.binding.InvocationContextFactory;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.interceptor.InvocationInterceptorChain;
import org.jfaster.mango.jdbc.JdbcOperations;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.Operator;
import org.jfaster.mango.operator.generator.DataSourceGenerator;
import org.jfaster.mango.operator.generator.TableGenerator;
import org.jfaster.mango.parser.ASTRootNode;

public abstract class AbstractOperator
implements Operator {
    protected final ASTRootNode rootNode;
    protected final Class<?> daoClass;
    protected InvocationInterceptorChain invocationInterceptorChain;
    protected TableGenerator tableGenerator;
    protected DataSourceGenerator dataSourceGenerator;
    protected InvocationContextFactory invocationContextFactory;
    protected JdbcOperations jdbcOperations;
    protected final Config config;

    protected AbstractOperator(ASTRootNode rootNode, MethodDescriptor md, Config config) {
        this.rootNode = rootNode;
        this.daoClass = md.getDaoClass();
        this.config = config.copy();
        this.mergeConfig(md);
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public void setInvocationContextFactory(InvocationContextFactory invocationContextFactory) {
        this.invocationContextFactory = invocationContextFactory;
    }

    public void setTableGenerator(TableGenerator tableGenerator) {
        this.tableGenerator = tableGenerator;
    }

    public void setDataSourceGenerator(DataSourceGenerator dataSourceGenerator) {
        this.dataSourceGenerator = dataSourceGenerator;
    }

    public void setInvocationInterceptorChain(InvocationInterceptorChain invocationInterceptorChain) {
        this.invocationInterceptorChain = invocationInterceptorChain;
    }

    private void mergeConfig(MethodDescriptor md) {
        UseTransactionForBatchUpdate anno = md.getAnnotation(UseTransactionForBatchUpdate.class);
        if (anno != null) {
            this.config.setUseTransactionForBatchUpdate(anno.value());
        }
    }
}

