/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.transaction.Transaction;
import org.jfaster.mango.transaction.TransactionFactory;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.ToStringHelper;

public class BatchUpdateOperator
extends AbstractOperator {
    protected Transformer transformer;
    private static final Map<Class, Transformer> TRANSFORMERS = new LinkedHashMap<Class, Transformer>();

    public BatchUpdateOperator(ASTRootNode rootNode, MethodDescriptor md, Config config) {
        super(rootNode, md, config);
        this.transformer = TRANSFORMERS.get(md.getReturnRawType());
        if (this.transformer == null) {
            String expected = ToStringHelper.toString(TRANSFORMERS.keySet());
            throw new DescriptionException("the return type of batch update expected one of " + expected + " but " + md.getReturnRawType());
        }
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        Iterables iterables = this.getIterables(values);
        if (iterables.isEmpty()) {
            return this.transformer.transform(new int[0]);
        }
        HashMap<DataSource, Group> gorupMap = new HashMap<DataSource, Group>();
        int t = 0;
        for (Object obj : iterables) {
            InvocationContext context = this.invocationContextFactory.newInvocationContext(new Object[]{obj});
            this.group(context, gorupMap, t++);
        }
        int[] ints = this.executeDb(gorupMap, t, stat);
        return this.transformer.transform(ints);
    }

    protected void group(InvocationContext context, Map<DataSource, Group> groupMap, int position) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        DataSource ds = this.dataSourceGenerator.getDataSource(context, this.daoClass);
        Group group = groupMap.get(ds);
        if (group == null) {
            group = new Group();
            groupMap.put(ds, group);
        }
        this.rootNode.render(context);
        BoundSql boundSql = context.getBoundSql();
        this.invocationInterceptorChain.intercept(boundSql, context, ds);
        group.add(boundSql, position);
    }

    protected Iterables getIterables(Object[] values) {
        Object firstValue = values[0];
        if (firstValue == null) {
            throw new NullPointerException("batchUpdate's parameter can't be null");
        }
        Iterables iterables = new Iterables(firstValue);
        return iterables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeDb(Map<DataSource, Group> groupMap, int batchNum, InvocationStat stat) {
        int[] r = new int[batchNum];
        long now = System.nanoTime();
        int t = 0;
        try {
            for (Map.Entry<DataSource, Group> entry : groupMap.entrySet()) {
                DataSource ds = entry.getKey();
                List<BoundSql> boundSqls = entry.getValue().getBoundSqls();
                List<Integer> positions = entry.getValue().getPositions();
                int[] ints = this.config.isUseTransactionForBatchUpdate() ? this.useTransactionBatchUpdate(ds, boundSqls) : this.jdbcOperations.batchUpdate(ds, boundSqls);
                for (int i = 0; i < ints.length; ++i) {
                    r[positions.get((int)i).intValue()] = ints[i];
                }
                ++t;
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (t == groupMap.entrySet().size()) {
                stat.recordDatabaseExecuteSuccess(cost);
            } else {
                stat.recordDatabaseExecuteException(cost);
            }
        }
        return r;
    }

    private int[] useTransactionBatchUpdate(DataSource ds, List<BoundSql> boundSqls) {
        int[] ints;
        Transaction transaction = TransactionFactory.newTransaction(ds);
        try {
            ints = this.jdbcOperations.batchUpdate(ds, boundSqls);
        }
        catch (RuntimeException e) {
            transaction.rollback();
            throw e;
        }
        transaction.commit();
        return ints;
    }

    static {
        TRANSFORMERS.put(Void.TYPE, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(int[].class, IntArrayTransformer.INSTANCE);
        TRANSFORMERS.put(Void.class, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Integer[].class, IntegerArrayTransformer.INSTANCE);
    }

    static enum VoidTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            return null;
        }
    }

    static enum IntegerTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            int r = 0;
            for (int e : s) {
                r += e;
            }
            return r;
        }
    }

    static enum IntegerArrayTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            Integer[] r = new Integer[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = s[i];
            }
            return r;
        }
    }

    static enum IntArrayTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(int[] s) {
            return s;
        }
    }

    public static interface Transformer {
        public Object transform(int[] var1);
    }

    protected static class Group {
        private List<BoundSql> boundSqls = new LinkedList<BoundSql>();
        private List<Integer> positions = new LinkedList<Integer>();

        protected Group() {
        }

        public void add(BoundSql boundSql, int position) {
            this.boundSqls.add(boundSql);
            this.positions.add(position);
        }

        public List<BoundSql> getBoundSqls() {
            return this.boundSqls;
        }

        public List<Integer> getPositions() {
            return this.positions;
        }
    }
}

