/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.datasource.DataSourceFactory;
import org.jfaster.mango.datasource.DataSourceFactoryGroup;
import org.jfaster.mango.datasource.SimpleDataSourceFactory;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.Methods;
import org.jfaster.mango.exception.InitializationException;
import org.jfaster.mango.interceptor.Interceptor;
import org.jfaster.mango.interceptor.InterceptorChain;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.Operator;
import org.jfaster.mango.operator.OperatorFactory;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.stat.CombinedStat;
import org.jfaster.mango.stat.InitStat;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.stat.MetaStat;
import org.jfaster.mango.stat.StatCollector;
import org.jfaster.mango.stat.StatInfo;
import org.jfaster.mango.stat.StatMonitor;
import org.jfaster.mango.util.ToStringHelper;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.DoubleCheckCache;
import org.jfaster.mango.util.local.LoadingCache;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;
import org.jfaster.mango.util.reflect.AbstractInvocationHandler;
import org.jfaster.mango.util.reflect.Reflection;

public class Mango
extends Config {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Mango.class);
    private DataSourceFactoryGroup dataSourceFactoryGroup;
    private CacheHandler cacheHandler;
    private boolean isLazyInit = false;
    private InterceptorChain interceptorChain = new InterceptorChain();
    private final StatCollector statCollector = new StatCollector();
    private static final CopyOnWriteArrayList<Mango> instances = new CopyOnWriteArrayList();

    private Mango() {
    }

    public static synchronized Mango newInstance() {
        if (instances.size() == 1 && logger.isWarnEnabled()) {
            logger.warn("Find out more mango instances, it is recommended to use only one");
        }
        Mango mango = new Mango();
        instances.add(mango);
        return mango;
    }

    public static Mango newInstance(DataSource dataSource) {
        Mango mango = Mango.newInstance();
        mango.setDataSource(dataSource);
        return mango;
    }

    public static Mango newInstance(DataSourceFactory dataSourceFactory) {
        Mango mango = Mango.newInstance();
        mango.setDataSourceFactory(dataSourceFactory);
        return mango;
    }

    public static Mango newInstance(DataSourceFactory ... dataSourceFactories) {
        return Mango.newInstance(Arrays.asList(dataSourceFactories));
    }

    public static Mango newInstance(List<DataSourceFactory> dataSourceFactories) {
        Mango mango = Mango.newInstance();
        mango.setDataSourceFactories(dataSourceFactories);
        return mango;
    }

    public static Mango newInstance(DataSourceFactory dataSourceFactory, CacheHandler cacheHandler) {
        Mango mango = Mango.newInstance();
        mango.setDataSourceFactory(dataSourceFactory);
        mango.setCacheHandler(cacheHandler);
        return mango;
    }

    public static Mango newInstance(List<DataSourceFactory> dataSourceFactories, CacheHandler cacheHandler) {
        Mango mango = Mango.newInstance();
        mango.setDataSourceFactories(dataSourceFactories);
        mango.setCacheHandler(cacheHandler);
        return mango;
    }

    public static List<Mango> getInstances() {
        ArrayList<Mango> mangos = new ArrayList<Mango>();
        for (Mango instance : instances) {
            mangos.add(instance);
        }
        return Collections.unmodifiableList(mangos);
    }

    public void addInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor can't be null");
        }
        if (this.interceptorChain == null) {
            this.interceptorChain = new InterceptorChain();
        }
        this.interceptorChain.addInterceptor(interceptor);
    }

    public <T> T create(Class<T> daoClass) {
        if (daoClass == null) {
            throw new NullPointerException("dao interface can't be null");
        }
        if (!daoClass.isInterface()) {
            throw new IllegalArgumentException("expected an interface to proxy, but " + daoClass);
        }
        DB dbAnno = daoClass.getAnnotation(DB.class);
        if (dbAnno == null) {
            throw new IllegalStateException("dao interface expected one @DB annotation but not found");
        }
        Cache cacheAnno = daoClass.getAnnotation(Cache.class);
        if (cacheAnno != null && this.cacheHandler == null) {
            throw new IllegalStateException("if @Cache annotation on dao interface, cacheHandler can't be null");
        }
        if (this.dataSourceFactoryGroup == null) {
            throw new IllegalArgumentException("please set dataSource or dataSourceFactory or dataSourceFactories");
        }
        MangoInvocationHandler handler = new MangoInvocationHandler(daoClass, this.dataSourceFactoryGroup, this.cacheHandler, this.interceptorChain, this.statCollector, this);
        if (!this.isLazyInit) {
            List<Method> methods = Methods.listMethods(daoClass);
            for (Method method : methods) {
                try {
                    handler.getOperator(method);
                }
                catch (Throwable e) {
                    throw new InitializationException("initialize " + ToStringHelper.toString(method) + " error", e);
                }
            }
        }
        return Reflection.newProxy(daoClass, handler);
    }

    public StatInfo getStatInfo() {
        return this.statCollector.getStatInfo();
    }

    public DataSource getMasterDataSource(String name) {
        return this.dataSourceFactoryGroup.getMasterDataSource(name);
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource can't be null");
        }
        this.setDataSourceFactory(new SimpleDataSourceFactory(dataSource));
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory can't be null");
        }
        this.setDataSourceFactories(Arrays.asList(dataSourceFactory));
    }

    public void addDataSourceFactory(DataSourceFactory dataSourceFactory) {
        if (dataSourceFactory == null) {
            throw new NullPointerException("dataSourceFactory can't be null");
        }
        if (this.dataSourceFactoryGroup == null) {
            this.dataSourceFactoryGroup = new DataSourceFactoryGroup();
        }
        this.dataSourceFactoryGroup.addDataSourceFactory(dataSourceFactory);
    }

    public void setDataSourceFactories(List<DataSourceFactory> dataSourceFactories) {
        if (dataSourceFactories == null || dataSourceFactories.isEmpty()) {
            throw new IllegalArgumentException("dataSourceFactories can't be null or empty");
        }
        this.dataSourceFactoryGroup = new DataSourceFactoryGroup(dataSourceFactories);
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(CacheHandler cacheHandler) {
        if (cacheHandler == null) {
            throw new NullPointerException("cacheHandler can't be null");
        }
        this.cacheHandler = cacheHandler;
    }

    public boolean isLazyInit() {
        return this.isLazyInit;
    }

    public void setLazyInit(boolean isLazyInit) {
        this.isLazyInit = isLazyInit;
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        if (interceptorChain == null) {
            throw new NullPointerException("interceptorChain can't be null");
        }
        this.interceptorChain = interceptorChain;
    }

    public void setStatMonitor(StatMonitor statMonitor) {
        this.statCollector.initStatMonitor(statMonitor);
    }

    public void shutDownStatMonitor() {
        this.statCollector.shutDown();
    }

    private static class MangoInvocationHandler
    extends AbstractInvocationHandler
    implements InvocationHandler {
        private final Class<?> daoClass;
        private final StatCollector statCollector;
        private final OperatorFactory operatorFactory;
        private final boolean isUseActualParamName;
        private final LoadingCache<Method, Operator> cache = new DoubleCheckCache<Method, Operator>(new CacheLoader<Method, Operator>(){

            @Override
            public Operator load(Method method) {
                if (logger.isInfoEnabled()) {
                    logger.info("Initializing operator for {}", (Object)ToStringHelper.toString(method));
                }
                CombinedStat combinedStat = MangoInvocationHandler.this.statCollector.getCombinedStat(method);
                MetaStat metaStat = combinedStat.getMetaStat();
                InitStat initStat = combinedStat.getInitStat();
                long now = System.nanoTime();
                MethodDescriptor md = Methods.getMethodDescriptor(MangoInvocationHandler.this.daoClass, method, MangoInvocationHandler.this.isUseActualParamName);
                AbstractOperator operator = MangoInvocationHandler.this.operatorFactory.getOperator(md, metaStat);
                initStat.recordInit(System.nanoTime() - now);
                metaStat.setDaoClass(MangoInvocationHandler.this.daoClass);
                metaStat.setMethod(method);
                metaStat.setSql(md.getSQL());
                return operator;
            }
        });

        private MangoInvocationHandler(Class<?> daoClass, DataSourceFactoryGroup dataSourceFactoryGroup, CacheHandler cacheHandler, InterceptorChain interceptorChain, StatCollector statCollector, Config config) {
            this.daoClass = daoClass;
            this.statCollector = statCollector;
            this.isUseActualParamName = config.isUseActualParamName();
            this.operatorFactory = new OperatorFactory(dataSourceFactoryGroup, cacheHandler, interceptorChain, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking {}", (Object)ToStringHelper.toString(method));
            }
            Operator operator = this.getOperator(method);
            InvocationStat stat = InvocationStat.create();
            try {
                Object r;
                Object object = r = operator.execute(args, stat);
                return object;
            }
            finally {
                this.statCollector.getCombinedStat(method).getExecuteStat().accumulate(stat);
            }
        }

        Operator getOperator(Method method) {
            return this.cache.get(method);
        }
    }
}

