/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.annotation.UseMaster;
import org.jfaster.mango.binding.DefaultParameterContext;
import org.jfaster.mango.binding.InvocationContextFactory;
import org.jfaster.mango.datasource.DataSourceFactoryGroup;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.interceptor.InterceptorChain;
import org.jfaster.mango.interceptor.InvocationInterceptorChain;
import org.jfaster.mango.jdbc.JdbcOperations;
import org.jfaster.mango.jdbc.JdbcTemplate;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.BatchUpdateOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.QueryOperator;
import org.jfaster.mango.operator.UpdateOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.operator.cache.CacheableBatchUpdateOperator;
import org.jfaster.mango.operator.cache.CacheableQueryOperator;
import org.jfaster.mango.operator.cache.CacheableUpdateOperator;
import org.jfaster.mango.operator.generator.DataSourceGenerator;
import org.jfaster.mango.operator.generator.DataSourceGeneratorFactory;
import org.jfaster.mango.operator.generator.TableGenerator;
import org.jfaster.mango.operator.generator.TableGeneratorFactory;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.parser.SqlParser;
import org.jfaster.mango.stat.MetaStat;
import org.jfaster.mango.util.jdbc.OperatorType;
import org.jfaster.mango.util.jdbc.SQLType;

public class OperatorFactory {
    private final CacheHandler cacheHandler;
    private final InterceptorChain interceptorChain;
    private final JdbcOperations jdbcOperations;
    private final Config config;
    private final TableGeneratorFactory tableGeneratorFactory;
    private final DataSourceGeneratorFactory dataSourceGeneratorFactory;

    public OperatorFactory(DataSourceFactoryGroup dataSourceFactoryGroup, CacheHandler cacheHandler, InterceptorChain interceptorChain, Config config) {
        this.cacheHandler = cacheHandler;
        this.interceptorChain = interceptorChain;
        this.config = config;
        this.jdbcOperations = new JdbcTemplate();
        this.tableGeneratorFactory = new TableGeneratorFactory();
        this.dataSourceGeneratorFactory = new DataSourceGeneratorFactory(dataSourceFactoryGroup);
    }

    public AbstractOperator getOperator(MethodDescriptor md, MetaStat stat) {
        AbstractOperator operator;
        ASTRootNode rootNode = SqlParser.parse(md.getSQL()).init();
        List<ParameterDescriptor> pds = md.getParameterDescriptors();
        OperatorType operatorType = this.getOperatorType(pds, rootNode);
        stat.setOperatorType(operatorType);
        if (operatorType == OperatorType.BATCHUPDATE) {
            ParameterDescriptor pd = pds.get(0);
            pds = new ArrayList<ParameterDescriptor>(1);
            pds.add(ParameterDescriptor.create(0, pd.getMappedClass(), pd.getAnnotations(), pd.getName()));
        }
        DefaultParameterContext context = DefaultParameterContext.create(pds);
        rootNode.expandParameter(context);
        rootNode.checkAndBind(context);
        boolean isSqlUseGlobalTable = !rootNode.getASTGlobalTables().isEmpty();
        TableGenerator tableGenerator = this.tableGeneratorFactory.getTableGenerator(md.getShardingAnno(), md.getGlobalTable(), isSqlUseGlobalTable, context);
        DataSourceType dataSourceType = this.getDataSourceType(operatorType, md);
        DataSourceGenerator dataSourceGenerator = this.dataSourceGeneratorFactory.getDataSourceGenerator(dataSourceType, md.getShardingAnno(), md.getDataSourceFactoryName(), context);
        if (md.isUseCache()) {
            CacheDriver driver = new CacheDriver(md, rootNode, this.cacheHandler, context);
            stat.setCacheable(true);
            stat.setUseMultipleKeys(driver.isUseMultipleKeys());
            stat.setCacheNullObject(driver.isCacheNullObject());
            switch (operatorType) {
                case QUERY: {
                    operator = new CacheableQueryOperator(rootNode, md, driver, this.config);
                    break;
                }
                case UPDATE: {
                    operator = new CacheableUpdateOperator(rootNode, md, driver, this.config);
                    break;
                }
                case BATCHUPDATE: {
                    operator = new CacheableBatchUpdateOperator(rootNode, md, driver, this.config);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            switch (operatorType) {
                case QUERY: {
                    operator = new QueryOperator(rootNode, md, this.config);
                    break;
                }
                case UPDATE: {
                    operator = new UpdateOperator(rootNode, md, this.config);
                    break;
                }
                case BATCHUPDATE: {
                    operator = new BatchUpdateOperator(rootNode, md, this.config);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        InvocationInterceptorChain chain = new InvocationInterceptorChain(this.interceptorChain, pds, rootNode.getSQLType());
        operator.setTableGenerator(tableGenerator);
        operator.setDataSourceGenerator(dataSourceGenerator);
        operator.setInvocationContextFactory(InvocationContextFactory.create(context));
        operator.setInvocationInterceptorChain(chain);
        operator.setJdbcOperations(this.jdbcOperations);
        return operator;
    }

    OperatorType getOperatorType(List<ParameterDescriptor> pds, ASTRootNode rootNode) {
        OperatorType operatorType;
        if (rootNode.getSQLType() == SQLType.SELECT) {
            operatorType = OperatorType.QUERY;
        } else {
            ParameterDescriptor pd;
            operatorType = OperatorType.UPDATE;
            if (pds.size() == 1 && (pd = pds.get(0)).isIterable() && rootNode.getJDBCIterableParameters().isEmpty()) {
                operatorType = OperatorType.BATCHUPDATE;
            }
        }
        return operatorType;
    }

    DataSourceType getDataSourceType(OperatorType operatorType, MethodDescriptor md) {
        DataSourceType dataSourceType = DataSourceType.SLAVE;
        if (operatorType != OperatorType.QUERY || md.isAnnotationPresent(UseMaster.class)) {
            dataSourceType = DataSourceType.MASTER;
        }
        return dataSourceType;
    }
}

