/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.annotation.Column;
import org.jfaster.mango.annotation.Mapper;
import org.jfaster.mango.annotation.Result;
import org.jfaster.mango.annotation.Results;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.ReturnDescriptor;
import org.jfaster.mango.jdbc.ArrayListSuppliter;
import org.jfaster.mango.jdbc.HashSetSupplier;
import org.jfaster.mango.jdbc.LinkedListSuppliter;
import org.jfaster.mango.jdbc.ListSupplier;
import org.jfaster.mango.jdbc.SetSupplier;
import org.jfaster.mango.mapper.BeanPropertyRowMapper;
import org.jfaster.mango.mapper.RowMapper;
import org.jfaster.mango.mapper.SingleColumnRowMapper;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.parser.EmptyObjectException;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.type.TypeHandlerRegistry;
import org.jfaster.mango.util.bean.BeanUtil;
import org.jfaster.mango.util.bean.PropertyMeta;
import org.jfaster.mango.util.reflect.Reflection;

public class QueryOperator
extends AbstractOperator {
    protected RowMapper<?> rowMapper;
    protected ReturnDescriptor returnDescriptor;
    protected ListSupplier listSupplier;
    protected SetSupplier setSupplier;

    public QueryOperator(ASTRootNode rootNode, MethodDescriptor md, Config config) {
        super(rootNode, md, config);
        this.init(md);
    }

    private void init(MethodDescriptor md) {
        this.returnDescriptor = md.getReturnDescriptor();
        this.rowMapper = this.getRowMapper(this.returnDescriptor.getMappedClass(), this.returnDescriptor);
        if (this.returnDescriptor.isCollection() || this.returnDescriptor.isList() || this.returnDescriptor.isLinkedList()) {
            this.listSupplier = new LinkedListSuppliter();
        } else if (this.returnDescriptor.isArrayList()) {
            this.listSupplier = new ArrayListSuppliter();
        } else if (this.returnDescriptor.isSetAssignable()) {
            this.setSupplier = new HashSetSupplier();
        }
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.execute(context, stat);
    }

    protected Object execute(InvocationContext context, InvocationStat stat) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        try {
            this.rootNode.render(context);
        }
        catch (EmptyObjectException e) {
            if (this.config.isCompatibleWithEmptyList()) {
                return this.EmptyObject();
            }
            throw e;
        }
        BoundSql boundSql = context.getBoundSql();
        DataSource ds = this.dataSourceGenerator.getDataSource(context, this.daoClass);
        this.invocationInterceptorChain.intercept(boundSql, context, ds);
        return this.executeFromDb(ds, boundSql, stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeFromDb(final DataSource ds, final BoundSql boundSql, InvocationStat stat) {
        Object r;
        boolean success = false;
        long now = System.nanoTime();
        try {
            r = new QueryVisitor(){

                @Override
                Object visitForList() {
                    return QueryOperator.this.jdbcOperations.queryForList(ds, boundSql, QueryOperator.this.listSupplier, QueryOperator.this.rowMapper);
                }

                @Override
                Object visitForSet() {
                    return QueryOperator.this.jdbcOperations.queryForSet(ds, boundSql, QueryOperator.this.setSupplier, QueryOperator.this.rowMapper);
                }

                @Override
                Object visitForArray() {
                    return QueryOperator.this.jdbcOperations.queryForArray(ds, boundSql, QueryOperator.this.rowMapper);
                }

                @Override
                Object visitForObject() {
                    return QueryOperator.this.jdbcOperations.queryForObject(ds, boundSql, QueryOperator.this.rowMapper);
                }
            }.visit();
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                stat.recordDatabaseExecuteSuccess(cost);
            } else {
                stat.recordDatabaseExecuteException(cost);
            }
        }
        return r;
    }

    private <T> RowMapper<?> getRowMapper(Class<T> clazz, ReturnDescriptor rd) {
        Result[] resultAnnos;
        Mapper mapperAnno = rd.getAnnotation(Mapper.class);
        if (mapperAnno != null) {
            return Reflection.instantiateClass(mapperAnno.value());
        }
        if (TypeHandlerRegistry.hasTypeHandler(clazz)) {
            return new SingleColumnRowMapper<T>(clazz);
        }
        Results resultsAnoo = rd.getAnnotation(Results.class);
        Map<String, String> ptc = this.getPropToColMap(clazz);
        if (resultsAnoo != null && (resultAnnos = resultsAnoo.value()) != null) {
            for (Result resultAnno : resultAnnos) {
                ptc.put(resultAnno.property().trim(), resultAnno.column().trim());
            }
        }
        return new BeanPropertyRowMapper<T>(clazz, ptc, this.config.isCheckColumn());
    }

    private Map<String, String> getPropToColMap(Class<?> clazz) {
        HashMap<String, String> propToColMap = new HashMap<String, String>();
        for (PropertyMeta propertyMeta : BeanUtil.fetchPropertyMetas(clazz)) {
            Column colAnno = propertyMeta.getPropertyAnno(Column.class);
            if (colAnno == null) continue;
            String prop = propertyMeta.getName();
            String col = colAnno.value();
            propToColMap.put(prop, col);
        }
        return propToColMap;
    }

    protected Object EmptyObject() {
        return new QueryVisitor(){

            @Override
            Object visitForList() {
                return QueryOperator.this.listSupplier.get(QueryOperator.this.rowMapper.getMappedClass());
            }

            @Override
            Object visitForSet() {
                return QueryOperator.this.setSupplier.get(QueryOperator.this.rowMapper.getMappedClass());
            }

            @Override
            Object visitForArray() {
                return Array.newInstance(QueryOperator.this.rowMapper.getMappedClass(), 0);
            }

            @Override
            Object visitForObject() {
                return null;
            }
        }.visit();
    }

    abstract class QueryVisitor {
        QueryVisitor() {
        }

        public Object visit() {
            Object r = QueryOperator.this.returnDescriptor.isCollection() || QueryOperator.this.returnDescriptor.isListAssignable() ? this.visitForList() : (QueryOperator.this.returnDescriptor.isSetAssignable() ? this.visitForSet() : (QueryOperator.this.returnDescriptor.isArray() ? this.visitForArray() : this.visitForObject()));
            return r;
        }

        abstract Object visitForList();

        abstract Object visitForSet();

        abstract Object visitForArray();

        abstract Object visitForObject();
    }
}

