/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.jdbc.GeneratedKeyHolder;
import org.jfaster.mango.operator.AbstractOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.parser.EmptyObjectException;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.type.TypeHandlerRegistry;
import org.jfaster.mango.util.ToStringHelper;
import org.jfaster.mango.util.jdbc.SQLType;

public class UpdateOperator
extends AbstractOperator {
    private boolean returnGeneratedId;
    private Transformer transformer;
    private TypeHandler<? extends Number> generatedKeyTypeHandler;
    private static final Map<Class, Transformer> TRANSFORMERS = new LinkedHashMap<Class, Transformer>();
    private static final Map<Class, GeneratedTransformer> GENERATED_TRANSFORMERS;

    public UpdateOperator(ASTRootNode rootNode, MethodDescriptor md, Config config) {
        super(rootNode, md, config);
        this.init(md, rootNode.getSQLType());
    }

    private void init(MethodDescriptor md, SQLType sqlType) {
        this.returnGeneratedId = md.isReturnGeneratedId() && sqlType == SQLType.INSERT;
        Class<?> returnRawType = md.getReturnRawType();
        if (this.returnGeneratedId) {
            GeneratedTransformer gt = GENERATED_TRANSFORMERS.get(returnRawType);
            if (gt == null) {
                String expected = ToStringHelper.toString(GENERATED_TRANSFORMERS.keySet());
                throw new DescriptionException("the return type of update(returnGeneratedId) expected one of " + expected + " but " + returnRawType);
            }
            this.generatedKeyTypeHandler = TypeHandlerRegistry.getTypeHandler(gt.getRawType());
            this.transformer = gt;
        } else {
            this.transformer = TRANSFORMERS.get(returnRawType);
            if (this.transformer == null) {
                String expected = ToStringHelper.toString(TRANSFORMERS.keySet());
                throw new DescriptionException("the return type of update expected one of " + expected + " but " + returnRawType);
            }
        }
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.execute(context, stat);
    }

    public Object execute(InvocationContext context, InvocationStat stat) {
        context.setGlobalTable(this.tableGenerator.getTable(context));
        try {
            this.rootNode.render(context);
        }
        catch (EmptyObjectException e) {
            if (this.config.isCompatibleWithEmptyList()) {
                return this.transformer.transform(0);
            }
            throw e;
        }
        BoundSql boundSql = context.getBoundSql();
        DataSource ds = this.dataSourceGenerator.getDataSource(context, this.daoClass);
        this.invocationInterceptorChain.intercept(boundSql, context, ds);
        Number r = this.executeDb(ds, boundSql, stat);
        return this.transformer.transform(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number executeDb(DataSource ds, BoundSql boundSql, InvocationStat stat) {
        Number r = null;
        long now = System.nanoTime();
        try {
            if (this.returnGeneratedId) {
                GeneratedKeyHolder holder = new GeneratedKeyHolder(this.generatedKeyTypeHandler);
                this.jdbcOperations.update(ds, boundSql, holder);
                r = holder.getKey();
            } else {
                r = this.jdbcOperations.update(ds, boundSql);
            }
        }
        finally {
            long cost = System.nanoTime() - now;
            if (r != null) {
                stat.recordDatabaseExecuteSuccess(cost);
            } else {
                stat.recordDatabaseExecuteException(cost);
            }
        }
        return r;
    }

    static {
        TRANSFORMERS.put(Void.TYPE, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Long.TYPE, LongTransformer.INSTANCE);
        TRANSFORMERS.put(Boolean.TYPE, BooleanTransformer.INSTANCE);
        TRANSFORMERS.put(Void.class, VoidTransformer.INSTANCE);
        TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        TRANSFORMERS.put(Long.class, LongTransformer.INSTANCE);
        TRANSFORMERS.put(Boolean.class, BooleanTransformer.INSTANCE);
        GENERATED_TRANSFORMERS = new LinkedHashMap<Class, GeneratedTransformer>();
        GENERATED_TRANSFORMERS.put(Integer.TYPE, IntegerTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Long.TYPE, LongTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Integer.class, IntegerTransformer.INSTANCE);
        GENERATED_TRANSFORMERS.put(Long.class, LongTransformer.INSTANCE);
    }

    static enum BooleanTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static enum VoidTransformer implements Transformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return null;
        }
    }

    static enum LongTransformer implements GeneratedTransformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.longValue();
        }

        @Override
        public Class<? extends Number> getRawType() {
            return Long.TYPE;
        }
    }

    static enum IntegerTransformer implements GeneratedTransformer
    {
        INSTANCE;


        @Override
        public Object transform(Number n) {
            return n.intValue();
        }

        @Override
        public Class<? extends Number> getRawType() {
            return Integer.TYPE;
        }
    }

    static interface GeneratedTransformer
    extends Transformer {
        public Class<? extends Number> getRawType();
    }

    static interface Transformer {
        public Object transform(Number var1);
    }
}

