/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Cache;
import org.jfaster.mango.annotation.CacheBy;
import org.jfaster.mango.annotation.CacheIgnored;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.binding.ParameterContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.operator.cache.CacheBase;
import org.jfaster.mango.operator.cache.CacheExpire;
import org.jfaster.mango.operator.cache.CacheHandler;
import org.jfaster.mango.operator.cache.CacheMultiKey;
import org.jfaster.mango.operator.cache.CacheSingleKey;
import org.jfaster.mango.operator.cache.IncorrectCacheByException;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTJDBCParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TypeWrapper;

public class CacheDriver
implements CacheBase,
CacheSingleKey,
CacheMultiKey {
    private CacheHandler cacheHandler;
    private Class<?> daoClass;
    private Type returnType;
    private Type elementType;
    private String prefix;
    private CacheExpire cacheExpire;
    private int expireNum;
    private boolean cacheNullObject;
    private boolean cacheEmptyList;
    private List<CacheByItem> cacheByItems = new ArrayList<CacheByItem>();
    private boolean useMultipleKeys;
    private String propertyOfMapper;

    public CacheDriver(MethodDescriptor md, ASTRootNode rootNode, CacheHandler cacheHandler, ParameterContext context) {
        this.cacheHandler = cacheHandler;
        this.daoClass = md.getDaoClass();
        this.returnType = md.getReturnType();
        this.elementType = md.getReturnDescriptor().getMappedType();
        this.init(md, rootNode, context);
    }

    @Override
    public boolean isUseMultipleKeys() {
        return this.useMultipleKeys;
    }

    @Override
    public boolean isCacheNullObject() {
        return this.cacheNullObject;
    }

    @Override
    public boolean isCacheEmptyList() {
        return this.cacheEmptyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToCache(String key, Object value, InvocationStat stat) {
        boolean success = false;
        long now = System.nanoTime();
        try {
            this.cacheHandler.set(key, value, this.getExptimeSeconds(), this.daoClass);
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                stat.recordCacheSetSuccess(cost);
            } else {
                stat.recordCacheSetException(cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(String key, Object value, InvocationStat stat) {
        boolean success = false;
        long now = System.nanoTime();
        try {
            this.cacheHandler.add(key, value, this.getExptimeSeconds(), this.daoClass);
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                stat.recordCacheAddSuccess(cost);
            } else {
                stat.recordCacheAddException(cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(String key, InvocationStat stat) {
        boolean success = false;
        long now = System.nanoTime();
        try {
            this.cacheHandler.delete(key, this.daoClass);
            success = true;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                stat.recordCacheDeleteSuccess(cost);
            } else {
                stat.recordCacheDeleteException(cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDeleteFromCache(Set<String> keys, InvocationStat stat) {
        if (keys.size() > 0) {
            boolean success = false;
            long now = System.nanoTime();
            try {
                this.cacheHandler.batchDelete(keys, this.daoClass);
                success = true;
            }
            finally {
                long cost = System.nanoTime() - now;
                if (success) {
                    stat.recordCacheBatchDeleteSuccess(cost);
                } else {
                    stat.recordCacheBatchDeleteException(cost);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getFromCache(String key, InvocationStat stat) {
        boolean success = false;
        long now = System.nanoTime();
        try {
            Object value = this.cacheHandler.get(key, this.returnType, this.daoClass);
            success = true;
            Object object = value;
            return object;
        }
        finally {
            long cost = System.nanoTime() - now;
            if (success) {
                stat.recordCacheGetSuccess(cost);
            } else {
                stat.recordCacheGetException(cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Map<String, Object> getBulkFromCache(Set<String> keys, InvocationStat stat) {
        if (keys.size() > 0) {
            boolean success = false;
            long now = System.nanoTime();
            try {
                Map<String, Object> values = this.cacheHandler.getBulk(keys, this.elementType, this.daoClass);
                success = true;
                Map<String, Object> map = values;
                return map;
            }
            finally {
                long cost = System.nanoTime() - now;
                if (success) {
                    stat.recordCacheGetBulkSuccess(cost);
                } else {
                    stat.recordCacheGetBulkException(cost);
                }
            }
        }
        return null;
    }

    @Override
    public String getCacheKey(InvocationContext context) {
        StringBuilder key = new StringBuilder(this.prefix);
        for (CacheByItem item : this.cacheByItems) {
            Object obj = context.getBindingValue(item.getbindingParameterInvoker());
            if (obj == null) {
                throw new NullPointerException("value of " + item.getFullName() + " can't be null");
            }
            key.append("_").append(obj);
        }
        return key.toString();
    }

    @Override
    public Class<?> getOnlyCacheByClass() {
        return CacheDriver.getOnlyCacheByItem(this.cacheByItems).getActualClass();
    }

    @Override
    public Set<String> getCacheKeys(InvocationContext context) {
        Iterables iterables = new Iterables(this.getOnlyCacheByObj(context));
        HashSet<String> keys = new HashSet<String>();
        for (Object obj : iterables) {
            String key = this.getCacheKey(obj);
            keys.add(key);
        }
        return keys;
    }

    @Override
    public String getCacheKey(Object obj) {
        return this.prefix + "_" + obj;
    }

    @Override
    public Object getOnlyCacheByObj(InvocationContext context) {
        CacheByItem item = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
        Object obj = context.getBindingValue(item.getbindingParameterInvoker());
        if (obj == null) {
            throw new NullPointerException("value of " + item.getFullName() + " can't be null");
        }
        return obj;
    }

    @Override
    public void setOnlyCacheByObj(InvocationContext context, Object obj) {
        CacheByItem item = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
        context.setBindingValue(item.getbindingParameterInvoker(), obj);
    }

    @Override
    public String getPropertyOfMapper() {
        return this.propertyOfMapper;
    }

    @Override
    public int getExptimeSeconds() {
        return this.cacheExpire.getExpireTime() * this.expireNum;
    }

    private void init(MethodDescriptor md, ASTRootNode rootNode, ParameterContext context) {
        for (ParameterDescriptor pd : md.getParameterDescriptors()) {
            CacheBy cacheByAnno = pd.getAnnotation(CacheBy.class);
            if (cacheByAnno == null) continue;
            String parameterName = context.getParameterNameByPosition(pd.getPosition());
            String propertyPaths = cacheByAnno.value();
            for (String propertyPath : propertyPaths.split(",")) {
                propertyPath = propertyPath.trim();
                BindingParameterInvoker invoker = context.getBindingParameterInvoker(BindingParameter.create(parameterName, propertyPath, null));
                Type cacheByType = invoker.getTargetType();
                TypeWrapper tw = new TypeWrapper(cacheByType);
                this.cacheByItems.add(new CacheByItem(parameterName, propertyPath, tw.getMappedClass(), invoker));
                this.useMultipleKeys = this.useMultipleKeys || tw.isIterable();
            }
        }
        int cacheByNum = this.cacheByItems.size();
        if (this.useMultipleKeys && cacheByNum > 1) {
            throw new IncorrectCacheByException("when @CacheBy modification interable parameter, there can be only one @CacheBy");
        }
        Cache cacheAnno = md.getAnnotation(Cache.class);
        CacheIgnored cacheIgnoredAnno = md.getAnnotation(CacheIgnored.class);
        if (cacheAnno != null) {
            if (cacheIgnoredAnno == null) {
                if (cacheByNum == 0) {
                    throw new IllegalStateException("if use cache, each method expected one or more @CacheBy annotation on parameter but found 0");
                }
                this.prefix = cacheAnno.prefix();
                this.cacheExpire = Reflection.instantiateClass(cacheAnno.expire());
                this.expireNum = cacheAnno.num();
                this.cacheNullObject = cacheAnno.cacheNullObject();
                this.cacheEmptyList = cacheAnno.cacheEmptyList();
                CacheDriver.checkCacheBy(rootNode, this.cacheByItems);
            } else if (cacheByNum > 0) {
                throw new DescriptionException("if @CacheIgnored is on method, @CacheBy can not on method's parameter");
            }
        } else {
            if (cacheByNum > 0) {
                throw new DescriptionException("if @Cache is not defined, @CacheBy can not on method's parameter");
            }
            if (cacheIgnoredAnno != null) {
                throw new DescriptionException("if @Cache is not defined, @CacheIgnored can not on method");
            }
        }
        if (this.useMultipleKeys) {
            CacheByItem cacheByItem = CacheDriver.getOnlyCacheByItem(this.cacheByItems);
            for (ASTJDBCIterableParameter jip : rootNode.getJDBCIterableParameters()) {
                if (!jip.getBindingParameter().getParameterName().equals(cacheByItem.getParameterName()) || !jip.getBindingParameter().getPropertyPath().equals(cacheByItem.getPropertyPath())) continue;
                this.propertyOfMapper = jip.getPropertyOfMapper();
                break;
            }
        }
    }

    private static CacheByItem getOnlyCacheByItem(List<CacheByItem> cacheByItems) {
        if (cacheByItems.size() != 1) {
            throw new IllegalStateException("size of cacheByItems expected 1 but " + cacheByItems.size());
        }
        return cacheByItems.get(0);
    }

    private static void checkCacheBy(ASTRootNode rootNode, List<CacheByItem> cacheByItems) {
        List<ASTJDBCParameter> jps = rootNode.getJDBCParameters();
        for (CacheByItem cacheByItem : cacheByItems) {
            String parameterName = cacheByItem.getParameterName();
            String propertyPath = cacheByItem.getPropertyPath();
            boolean pass = false;
            for (ASTJDBCParameter jp : jps) {
                if (!jp.getBindingParameter().getParameterName().equals(parameterName) || !jp.getBindingParameter().getPropertyPath().equals(propertyPath)) continue;
                pass = true;
                break;
            }
            List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
            for (ASTJDBCIterableParameter jip : jips) {
                if (!jip.getBindingParameter().getParameterName().equals(parameterName) || !jip.getBindingParameter().getPropertyPath().equals(propertyPath)) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            throw new IncorrectCacheByException("CacheBy " + cacheByItem.getFullName() + " can't match any db parameter");
        }
    }

    private static class CacheByItem {
        private final String parameterName;
        private final String propertyPath;
        private final Class<?> actualClass;
        private final BindingParameterInvoker bindingParameterInvoker;

        public CacheByItem(String parameterName, String propertyPath, Class<?> actualClass, BindingParameterInvoker bindingParameterInvoker) {
            this.parameterName = parameterName;
            this.propertyPath = propertyPath;
            this.actualClass = actualClass;
            this.bindingParameterInvoker = bindingParameterInvoker;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        private Class<?> getActualClass() {
            return this.actualClass;
        }

        private BindingParameterInvoker getbindingParameterInvoker() {
            return this.bindingParameterInvoker;
        }

        public String getFullName() {
            return Strings.getFullName(this.parameterName, this.propertyPath);
        }
    }
}

